/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.collections.DetachedThreadLocalImpl;
import co.elastic.apm.agent.collections.NullSafeWeakConcurrentMap;
import co.elastic.apm.agent.collections.NullSafeWeakConcurrentSet;
import co.elastic.apm.agent.collections.SpanConcurrentHashMap;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.sdk.weakconcurrent.DetachedThreadLocal;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakSet;
import com.blogspot.mydailyjava.weaklockfree.AbstractWeakConcurrentMap;
import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class WeakConcurrentProviderImpl
implements WeakConcurrent.WeakConcurrentProvider {
    private static final WeakConcurrentSet<AbstractWeakConcurrentMap<?, ?, ?>> registeredMaps = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.INLINE);

    public static <K, V extends AbstractSpan<?>> WeakMap<K, V> createWeakSpanMap() {
        SpanConcurrentHashMap map = new SpanConcurrentHashMap();
        NullSafeWeakConcurrentMap result = new NullSafeWeakConcurrentMap(map);
        registeredMaps.add(result);
        return result;
    }

    @Override
    public <K, V> WeakConcurrent.WeakMapBuilder<K, V> weakMapBuilder() {
        return new WeakConcurrent.WeakMapBuilder<K, V>(){
            @Nullable
            private WeakMap.DefaultValueSupplier<K, V> defaultValueSupplier;
            private int initialCapacity = 16;

            @Override
            public WeakConcurrent.WeakMapBuilder<K, V> withInitialCapacity(int initialCapacity) {
                this.initialCapacity = initialCapacity;
                return this;
            }

            @Override
            public WeakConcurrent.WeakMapBuilder<K, V> withDefaultValueSupplier(@Nullable WeakMap.DefaultValueSupplier<K, V> defaultValueSupplier) {
                this.defaultValueSupplier = defaultValueSupplier;
                return this;
            }

            @Override
            public WeakMap<K, V> build() {
                NullSafeWeakConcurrentMap map = new NullSafeWeakConcurrentMap(new ConcurrentHashMap(this.initialCapacity), this.defaultValueSupplier);
                registeredMaps.add(map);
                return map;
            }
        };
    }

    @Override
    public <T> WeakConcurrent.ThreadLocalBuilder<T> threadLocalBuilder() {
        return new WeakConcurrent.ThreadLocalBuilder<T>(){
            @Nullable
            private WeakMap.DefaultValueSupplier<Thread, T> defaultValueSupplier;

            @Override
            public WeakConcurrent.ThreadLocalBuilder<T> withDefaultValueSupplier(@Nullable WeakMap.DefaultValueSupplier<Thread, T> defaultValueSupplier) {
                this.defaultValueSupplier = defaultValueSupplier;
                return this;
            }

            @Override
            public DetachedThreadLocal<T> build() {
                return new DetachedThreadLocalImpl(WeakConcurrentProviderImpl.this.weakMapBuilder().withDefaultValueSupplier(this.defaultValueSupplier).build());
            }
        };
    }

    public <V> WeakSet<V> buildSet() {
        return new NullSafeWeakConcurrentSet(this.weakMapBuilder().build());
    }

    public static void expungeStaleEntries() {
        for (AbstractWeakConcurrentMap<?, ?, ?> weakMap : registeredMaps) {
            weakMap.expungeStaleEntries();
        }
    }
}

