/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.collections.NullCheck;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakSet;
import java.util.Iterator;
import java.util.Map;

public class NullSafeWeakConcurrentSet<V>
implements WeakSet<V> {
    private final WeakMap<V, Boolean> map;

    NullSafeWeakConcurrentSet(WeakMap<V, Boolean> map) {
        this.map = map;
    }

    @Override
    public boolean add(V value) {
        if (NullCheck.isNullValue(value)) {
            return false;
        }
        return this.map.put((Boolean)value, Boolean.TRUE) == null;
    }

    @Override
    public boolean contains(V value) {
        if (NullCheck.isNullValue(value)) {
            return false;
        }
        return this.map.containsKey(value);
    }

    @Override
    public boolean remove(V value) {
        if (NullCheck.isNullValue(value)) {
            return false;
        }
        return this.map.remove(value) != null;
    }

    @Override
    public Iterator<V> iterator() {
        return new ReducingIterator(this.map.iterator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<V> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static class ReducingIterator<V>
    implements Iterator<V> {
        private final Iterator<Map.Entry<V, Boolean>> iterator;

        private ReducingIterator(Iterator<Map.Entry<V, Boolean>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public V next() {
            return this.iterator.next().getKey();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

