/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import javax.annotation.Nullable;

public class NullCheck {
    @Nullable
    private static Logger logger;

    private static <T> boolean isNull(@Nullable T v, boolean isKey) {
        if (null != v) {
            return false;
        }
        String msg = String.format("trying to use null %s", isKey ? "key" : "value");
        if (logger != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(msg, new RuntimeException(msg));
            } else {
                logger.warn(msg);
            }
        }
        return true;
    }

    public static <T> boolean isNullKey(@Nullable T key) {
        return NullCheck.isNull(key, true);
    }

    public static <T> boolean isNullValue(@Nullable T value) {
        return NullCheck.isNull(value, false);
    }

    static {
        try {
            logger = LoggerFactory.getLogger(NullCheck.class);
        }
        catch (Throwable throwable) {
            System.err.println("[elastic-apm-agent] WARN Failed to initialize logger for the NullCheck class: " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }
}

