/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.cassandra4;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.cassandra.CassandraHelper;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Cassandra4Instrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Session");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("com.datastax.oss.driver.api.core.session.Session")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.returns(Object.class)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.datastax.oss.driver.api.core.session.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("com.datastax.oss.driver.api.core.type.reflect.GenericType")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("cassandra");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.cassandra4.Cassandra4Instrumentation$Cassandra4Advice";
    }

    public static class Cassandra4Advice {
        private static final CassandraHelper cassandraHelper = new CassandraHelper(GlobalTracer.get());

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.This Session thiz, @Advice.Argument(value=0) Request request) {
            String keyspace;
            if (!(request instanceof Statement)) {
                return null;
            }
            CqlIdentifier ks = request.getKeyspace();
            String string = keyspace = ks != null ? ks.toString() : null;
            if (ks == null) {
                keyspace = thiz.getKeyspace().map(CqlIdentifier::toString).orElse(null);
            }
            return cassandraHelper.startCassandraSpan(Cassandra4Advice.getQuery(request), request instanceof BoundStatement, keyspace);
        }

        @Nullable
        private static String getQuery(Request request) {
            if (request instanceof SimpleStatement) {
                return ((SimpleStatement)request).getQuery();
            }
            if (request instanceof BoundStatement) {
                return ((BoundStatement)request).getPreparedStatement().getQuery();
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.Return Object result, @Nullable @Advice.Enter Object spanObj) {
            if (!(spanObj instanceof Span)) {
                return;
            }
            Span span = (Span)spanObj;
            ((Span)span.captureException(thrown)).deactivate();
            if (result instanceof ResultSet) {
                Cassandra4Advice.setDestination(span, ((ResultSet)result).getExecutionInfo());
                span.end();
            } else if (result instanceof CompletionStage) {
                ((CompletionStage)result).whenComplete((r, t) -> {
                    if (r instanceof AsyncResultSet) {
                        Cassandra4Advice.setDestination(span, ((AsyncResultSet)r).getExecutionInfo());
                    }
                    ((Span)span.captureException((Throwable)t)).end();
                });
            } else {
                span.end();
            }
        }

        private static void setDestination(Span span, ExecutionInfo info) {
            Node coordinator = info.getCoordinator();
            if (coordinator != null) {
                span.getContext().getDestination().withSocketAddress(coordinator.getEndPoint().resolve());
            }
        }
    }
}

