/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.cassandra;

import co.elastic.apm.agent.db.signature.SignatureParser;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.Span;
import javax.annotation.Nullable;

public class CassandraHelper {
    private static final String CASSANDRA = "cassandra";
    private final Tracer tracer;
    private final SignatureParser signatureParser = new SignatureParser();

    public CassandraHelper(Tracer tracer) {
        this.tracer = tracer;
    }

    @Nullable
    public Span startCassandraSpan(@Nullable String query, boolean preparedStatement, @Nullable String keyspace) {
        Span span = this.tracer.createExitChildSpan();
        if (span == null) {
            return null;
        }
        ((Span)((Span)span.activate()).withType("db")).withSubtype(CASSANDRA);
        span.getContext().getDb().withStatement(query).withInstance(keyspace);
        StringBuilder name = span.getAndOverrideName(0);
        if (query != null && name != null) {
            this.signatureParser.querySignature(query, name, preparedStatement);
        }
        span.withName(CASSANDRA, -1);
        span.getContext().getServiceTarget().withType(CASSANDRA).withName(keyspace);
        return span;
    }
}

