/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.classloading;

import co.elastic.apm.agent.common.util.AgentInfo;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExternalPluginClassLoader
extends URLClassLoader {
    private final List<String> classNames;
    private final File pluginJar;

    public ExternalPluginClassLoader(File pluginJar, ClassLoader parent) throws IOException {
        super(new URL[]{pluginJar.toURI().toURL()}, parent);
        this.pluginJar = pluginJar;
        this.classNames = Collections.unmodifiableList(this.scanForClasses(pluginJar));
        if (this.classNames.contains(ElasticApmInstrumentation.class.getName())) {
            throw new IllegalStateException(String.format("The plugin %s contains the plugin SDK. Please make sure the scope for the dependency apm-agent-plugin-sdk is set to provided.", pluginJar.getName()));
        }
    }

    private List<String> scanForClasses(File pluginJar) throws IOException {
        ArrayList<String> tempClassNames = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(pluginJar);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                String fqcn = jarEntry.getName().replace('/', '.').substring(0, jarEntry.getName().length() - 6);
                if (fqcn.startsWith("org.slf4j") || fqcn.startsWith("org.apache.logging")) {
                    throw new IllegalStateException(String.format("Package \"%s\" is used within plugin %s. This is not allowed because it is already used by the agent. For logging purposes, use the agent SDK logging facade - %s", fqcn.substring(0, fqcn.lastIndexOf(46)), pluginJar.getName(), LoggerFactory.class.getName()));
                }
                for (String agentDependencyPackage : AgentInfo.getAgentDependencyPackages()) {
                    if (!fqcn.startsWith(agentDependencyPackage)) continue;
                    throw new IllegalStateException(String.format("Package \"%s\" is used within plugin %s. This is not allowed because the same dependency is used by the agent. Please either replace the corresponding dependency or make sure its scope is set to provided. See the full list of such packages in %s", fqcn.substring(0, fqcn.lastIndexOf(46)), pluginJar.getName(), AgentInfo.class.getName()));
                }
                tempClassNames.add(fqcn);
            }
        }
        return tempClassNames;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public String toString() {
        return "ExternalPluginClassLoader{pluginJar=" + this.pluginJar + ", parent =" + this.getParent() + '}';
    }
}

