/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.OpenedClassReader;
import org.objectweb.asm.ClassVisitor;

public enum MinimumClassFileVersionValidator implements AsmVisitorWrapper
{
    V1_4(ClassFileVersion.JAVA_V4, new UnsupportedClassFileVersionException("4")),
    V1_5(ClassFileVersion.JAVA_V5, new UnsupportedClassFileVersionException("5"));

    private final ClassFileVersion minimumClassFileVersion;
    private final UnsupportedClassFileVersionException exception;

    private MinimumClassFileVersionValidator(ClassFileVersion minimumClassFileVersion, UnsupportedClassFileVersionException exception) {
        this.minimumClassFileVersion = minimumClassFileVersion;
        this.exception = exception;
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new ClassVisitor(OpenedClassReader.ASM_API, classVisitor){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ClassFileVersion classFileVersion = ClassFileVersion.ofMinorMajor(version);
                if (!classFileVersion.isAtLeast(MinimumClassFileVersionValidator.this.minimumClassFileVersion)) {
                    throw MinimumClassFileVersionValidator.this.exception;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
    }

    @Override
    public int mergeWriter(int flags) {
        return flags;
    }

    @Override
    public int mergeReader(int flags) {
        return flags;
    }

    public static class UnsupportedClassFileVersionException
    extends RuntimeException {
        private final String minVersion;

        private UnsupportedClassFileVersionException(String minVersion) {
            this.minVersion = minVersion;
        }

        public String getMinVersion() {
            return this.minVersion;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

