/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodHierarchyMatcher
extends ElementMatcher.Junction.AbstractBase<MethodDescription> {
    private final ElementMatcher<? super MethodDescription> extraMethodMatcher;
    private final ElementMatcher<? super TypeDescription> superClassMatcher;
    private final ElementMatcher<? super TypeDescription> hierarchyMatcher;

    MethodHierarchyMatcher(ElementMatcher<? super MethodDescription> extraMethodMatcher) {
        this(extraMethodMatcher, ElementMatchers.not(ElementMatchers.is(TypeDescription.ForLoadedType.OBJECT)), ElementMatchers.any());
    }

    private MethodHierarchyMatcher(ElementMatcher<? super MethodDescription> extraMethodMatcher, ElementMatcher<? super TypeDescription> superClassMatcher, ElementMatcher<? super TypeDescription> hierachyMatcher) {
        this.extraMethodMatcher = extraMethodMatcher;
        this.superClassMatcher = superClassMatcher;
        this.hierarchyMatcher = hierachyMatcher;
    }

    public MethodHierarchyMatcher onSuperClassesThat(ElementMatcher<? super TypeDescription> superClassMatcher) {
        return new MethodHierarchyMatcher(this.extraMethodMatcher, superClassMatcher, this.hierarchyMatcher);
    }

    public MethodHierarchyMatcher whereHierarchyContains(ElementMatcher<? super TypeDescription> hierarchyMatcher) {
        return new MethodHierarchyMatcher(this.extraMethodMatcher, this.superClassMatcher, hierarchyMatcher);
    }

    @Override
    public boolean matches(MethodDescription targetMethod) {
        return this.declaresInHierarchy(targetMethod, targetMethod.getDeclaringType().asErasure(), new ArrayDeque<TypeDescription>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean declaresInHierarchy(MethodDescription targetMethod, TypeDescription type, Deque<TypeDescription> hierarchy) {
        hierarchy.push(type);
        try {
            if (ElementMatchers.declaresMethod(ElementMatchers.named(targetMethod.getName()).and(ElementMatchers.returns(targetMethod.getReturnType().asErasure())).and(ElementMatchers.takesArguments(targetMethod.getParameters().asTypeList().asErasures())).and(this.extraMethodMatcher)).matches(type) && !((TypeList)new TypeList.Explicit(new ArrayList<TypeDescription>(hierarchy)).filter(this.hierarchyMatcher)).isEmpty()) {
                boolean bl = true;
                return bl;
            }
            for (TypeDescription interfaze : type.getInterfaces().asErasures()) {
                if (!this.superClassMatcher.matches(interfaze) || !this.declaresInHierarchy(targetMethod, interfaze, hierarchy)) continue;
                boolean bl = true;
                return bl;
            }
            TypeDescription.Generic superClass = type.getSuperClass();
            if (superClass != null && this.superClassMatcher.matches(superClass.asErasure())) {
                boolean bl = this.declaresInHierarchy(targetMethod, superClass.asErasure(), hierarchy);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            hierarchy.pop();
        }
    }
}

