/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.bci.bytebuddy.Instrumented;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;

public class InstallationListenerImpl
extends AgentBuilder.InstallationListener.Adapter {
    @Override
    public void onAfterWarmUp(Map<Class<?>, byte[]> types, ResettableClassFileTransformer classFileTransformer, boolean transformed) {
        block9: {
            Logger logger = null;
            try {
                logger = LoggerFactory.getLogger(InstallationListenerImpl.class);
                if (!transformed) {
                    logger.warn("Byte Buddy warmup ended without transforming at least one class. The agent may not work as expected.");
                } else {
                    byte[] transformedInstrumentedClass = null;
                    for (Map.Entry<Class<?>, byte[]> classEntry : types.entrySet()) {
                        if (!classEntry.getKey().equals(Instrumented.class)) continue;
                        transformedInstrumentedClass = classEntry.getValue();
                        break;
                    }
                    String instrumentedClassName = Instrumented.class.getName();
                    if (transformedInstrumentedClass != null) {
                        logger.debug("Warmup: bytecode transformation of {} succeeded", (Object)instrumentedClassName);
                        HashMap<String, byte[]> typeDefinitions = new HashMap<String, byte[]>();
                        typeDefinitions.put(instrumentedClassName, transformedInstrumentedClass);
                        ByteArrayClassLoader.ChildFirst childFirstCL = new ByteArrayClassLoader.ChildFirst(null, typeDefinitions);
                        Class<?> instrumentedClass = childFirstCL.loadClass(instrumentedClassName);
                        Object instrumentedClassInstance = instrumentedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method isInstrumentedMethod = instrumentedClass.getDeclaredMethod("isInstrumented", new Class[0]);
                        boolean isInstrumented = (Boolean)isInstrumentedMethod.invoke(instrumentedClassInstance, new Object[0]);
                        if (isInstrumented) {
                            Instrumented.setWarmedUp();
                            logger.debug("Warmup: instrumented bytecode of {} was executed as expected", (Object)instrumentedClassName);
                        } else {
                            logger.warn("Warmup: instrumented bytecode of {} does not work as expected", (Object)instrumentedClassName);
                        }
                    } else {
                        logger.warn("Warmup did not include the {} class as expected", (Object)instrumentedClassName);
                    }
                }
            }
            catch (Throwable throwable) {
                if (logger == null) break block9;
                logger.error("Unexpected bytecode instrumentation warmup error", throwable);
            }
        }
    }

    @Override
    public void onWarmUpError(Class<?> type, ResettableClassFileTransformer classFileTransformer, Throwable throwable) {
        try {
            LoggerFactory.getLogger(InstallationListenerImpl.class).error("Error during warmup instrumentation of " + type.getName(), throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }
}

