/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.bci.bytebuddy.MinimumClassFileVersionValidator;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;

public class ErrorLoggingListener
extends AgentBuilder.Listener.Adapter {
    private static final Logger logger = LoggerFactory.getLogger(ErrorLoggingListener.class);

    @Override
    public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
        if (throwable instanceof MinimumClassFileVersionValidator.UnsupportedClassFileVersionException) {
            logger.warn("{} uses an unsupported class file version (pre Java {})) and can't be instrumented. You may try setting the '{}' config option to 'true', but notice that it may cause VerificationErrors or other issues.", typeName, ((MinimumClassFileVersionValidator.UnsupportedClassFileVersionException)throwable).getMinVersion(), "instrument_ancient_bytecode");
        } else if (throwable instanceof TypePool.Resolution.NoSuchTypeException) {
            logger.info(typeName + " refers to a missing class.");
            logger.debug("ByteBuddy type resolution stack trace: ", throwable);
        } else {
            logger.warn("Error on transformation " + typeName, throwable);
        }
    }
}

