/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.bci.bytebuddy.MethodHierarchyMatcher;
import co.elastic.apm.agent.matcher.AnnotationMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.util.ClassLoaderUtils;
import co.elastic.apm.agent.util.Version;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class CustomElementMatchers {
    private static final Logger logger = LoggerFactory.getLogger(CustomElementMatchers.class);
    private static final ElementMatcher.Junction.AbstractBase<ClassLoader> AGENT_CLASS_LOADER_MATCHER = new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

        @Override
        public boolean matches(@Nullable ClassLoader classLoader) {
            return ClassLoaderUtils.isAgentClassLoader(classLoader);
        }
    };
    private static final ElementMatcher.Junction.AbstractBase<ClassLoader> INTERNAL_PLUGIN_CLASS_LOADER_MATCHER = new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

        @Override
        public boolean matches(@Nullable ClassLoader classLoader) {
            boolean result = ClassLoaderUtils.isInternalPluginClassLoader(classLoader);
            return result;
        }
    };

    public static ElementMatcher.Junction<NamedElement> isInAnyPackage(Collection<String> includedPackages, ElementMatcher.Junction<NamedElement> defaultIfEmpty) {
        if (includedPackages.isEmpty()) {
            return defaultIfEmpty;
        }
        ElementMatcher.Junction<NamedElement> matcher = ElementMatchers.none();
        for (String applicationPackage : includedPackages) {
            matcher = matcher.or(ElementMatchers.nameStartsWith(applicationPackage));
        }
        return matcher;
    }

    public static ElementMatcher.Junction<ClassLoader> isSameClassLoader(final ClassLoader other) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

            @Override
            public boolean matches(@Nullable ClassLoader target) {
                return target == other;
            }
        };
    }

    public static ElementMatcher.Junction<ClassLoader> classLoaderCanLoadClass(final String className) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){
            private final boolean loadableByBootstrapClassLoader;
            private final WeakMap<ClassLoader, Boolean> cache;
            {
                this.loadableByBootstrapClassLoader = CustomElementMatchers.canLoadClass(null, className);
                this.cache = WeakConcurrent.buildMap();
            }

            @Override
            public boolean matches(@Nullable ClassLoader target) {
                if (target == null) {
                    return this.loadableByBootstrapClassLoader;
                }
                Boolean result = this.cache.get(target);
                if (result == null) {
                    result = CustomElementMatchers.canLoadClass(target, className);
                    this.cache.put(target, result);
                }
                return result;
            }
        };
    }

    private static boolean canLoadClass(@Nullable ClassLoader target, String className) {
        try {
            String classResource = className.replace('.', '/') + ".class";
            URL resource = target == null ? Object.class.getResource("/" + classResource) : target.getResource(classResource);
            return resource != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionLte(String version) {
        return CustomElementMatchers.implementationVersion(version, Matcher.LTE);
    }

    public static ElementMatcher.Junction<ProtectionDomain> implementationVersionGte(String version) {
        return CustomElementMatchers.implementationVersion(version, Matcher.GTE);
    }

    private static ElementMatcher.Junction<ProtectionDomain> implementationVersion(final String version, final Matcher matcher) {
        return new ElementMatcher.Junction.AbstractBase<ProtectionDomain>(){

            @Override
            public boolean matches(@Nullable ProtectionDomain protectionDomain) {
                try {
                    Version pdVersion = CustomElementMatchers.readImplementationVersionFromManifest(protectionDomain);
                    Version limitVersion = Version.of(version).withoutSuffix();
                    if (pdVersion != null) {
                        pdVersion = pdVersion.withoutSuffix();
                        return matcher.match(pdVersion, limitVersion);
                    }
                }
                catch (Exception e) {
                    logger.info("Cannot read implementation version based on ProtectionDomain. This should not affect your agent's functionality. Failed with message: " + e.getMessage());
                    logger.debug("Implementation version parsing error: " + protectionDomain, e);
                }
                return true;
            }
        };
    }

    public static ElementMatcher.Junction<ClassLoader> isAgentClassLoader() {
        return AGENT_CLASS_LOADER_MATCHER;
    }

    public static ElementMatcher.Junction<ClassLoader> isInternalPluginClassLoader() {
        return INTERNAL_PLUGIN_CLASS_LOADER_MATCHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Version readImplementationVersionFromManifest(@Nullable ProtectionDomain protectionDomain) throws IOException, URISyntaxException {
        Version version = null;
        ZipFile jarFile = null;
        try {
            if (protectionDomain != null) {
                URLConnection urlConnection;
                Manifest manifest;
                URL jarUrl;
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource != null && (jarUrl = codeSource.getLocation()) != null && (manifest = ((JarFile)(jarFile = (urlConnection = jarUrl.openConnection()) instanceof JarURLConnection ? ((JarURLConnection)urlConnection).getJarFile() : new JarFile(new File(jarUrl.toURI())))).getManifest()) != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    String manifestVersion = attributes.getValue("Implementation-Version");
                    if (manifestVersion == null) {
                        manifestVersion = attributes.getValue("Bundle-Version");
                    }
                    if (manifestVersion != null) {
                        version = Version.of(manifestVersion);
                    }
                }
            } else {
                logger.info("Cannot read implementation version - got null ProtectionDomain");
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    logger.error("Error closing JarFile", e);
                }
            }
        }
        return version;
    }

    public static MethodHierarchyMatcher overridesOrImplementsMethodThat(ElementMatcher<? super MethodDescription> methodElementMatcher) {
        return new MethodHierarchyMatcher(methodElementMatcher);
    }

    public static ElementMatcher.Junction<NamedElement> matches(final WildcardMatcher matcher) {
        return new ElementMatcher.Junction.AbstractBase<NamedElement>(){

            @Override
            public boolean matches(NamedElement target) {
                return matcher.matches(target.getActualName());
            }

            public String toString() {
                return "matches(" + matcher + ")";
            }
        };
    }

    public static ElementMatcher.Junction<NamedElement> anyMatch(final List<WildcardMatcher> matchers) {
        return new ElementMatcher.Junction.AbstractBase<NamedElement>(){

            @Override
            public boolean matches(NamedElement target) {
                return WildcardMatcher.isAnyMatch(matchers, target.getActualName());
            }

            public String toString() {
                return "matches(" + matchers + ")";
            }
        };
    }

    public static ElementMatcher.Junction<AnnotationSource> annotationMatches(String annotationWildcard) {
        return AnnotationMatcher.annotationMatcher(annotationWildcard);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> isProxy() {
        return ElementMatchers.nameContains("$Proxy").or(ElementMatchers.nameContains("$$")).or(ElementMatchers.nameContains("$JaxbAccessor")).or(ElementMatchers.nameContains("CGLIB")).or(ElementMatchers.nameContains("EnhancerBy"));
    }

    private static enum Matcher {
        LTE{

            @Override
            <T extends Comparable<T>> boolean match(T c1, T c2) {
                return c1.compareTo(c2) <= 0;
            }
        }
        ,
        GTE{

            @Override
            <T extends Comparable<T>> boolean match(T c1, T c2) {
                return c1.compareTo(c2) >= 0;
            }
        };


        abstract <T extends Comparable<T>> boolean match(T var1, T var2);
    }
}

