/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import net.bytebuddy.matcher.ElementMatcher;

public abstract class ClassLoaderNameMatcher {
    public static ElementMatcher.Junction<ClassLoader> classLoaderWithName(final String name) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

            @Override
            public boolean matches(ClassLoader target) {
                return target != null && target.getClass().getName().equals(name);
            }
        };
    }

    public static ElementMatcher.Junction<ClassLoader> classLoaderWithNamePrefix(final String name) {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

            @Override
            public boolean matches(ClassLoader target) {
                return target != null && target.getClass().getName().startsWith(name);
            }
        };
    }

    public static ElementMatcher.Junction<ClassLoader> isReflectionClassLoader() {
        return ClassLoaderNameMatcher.classLoaderWithName("sun.reflect.DelegatingClassLoader").or(ClassLoaderNameMatcher.classLoaderWithName("jdk.internal.reflect.DelegatingClassLoader"));
    }
}

