/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;

public class AnnotationValueOffsetMappingFactory
implements Advice.OffsetMapping.Factory<AnnotationValueExtractor> {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationValueOffsetMappingFactory.class);

    @Override
    public Class<AnnotationValueExtractor> getAnnotationType() {
        return AnnotationValueExtractor.class;
    }

    @Override
    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, final AnnotationDescription.Loadable<AnnotationValueExtractor> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            @Override
            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                return Advice.OffsetMapping.Target.ForStackManipulation.of(AnnotationValueOffsetMappingFactory.this.getAnnotationValue(instrumentedMethod, (AnnotationValueExtractor)annotation.load()));
            }
        };
    }

    @Nullable
    private Object getAnnotationValue(MethodDescription instrumentedMethod, AnnotationValueExtractor annotationValueExtractor) {
        MethodDescription methodDescription = instrumentedMethod;
        do {
            for (TypeDescription typeDescription : methodDescription.getDeclaredAnnotations().asTypeList()) {
                if (!ElementMatchers.named(annotationValueExtractor.annotationClassName()).matches(typeDescription)) continue;
                for (MethodDescription.InDefinedShape annotationMethod : typeDescription.getDeclaredMethods()) {
                    if (!annotationMethod.getName().equals(annotationValueExtractor.method())) continue;
                    return methodDescription.getDeclaredAnnotations().ofType(typeDescription).getValue(annotationMethod).resolve();
                }
            }
        } while ((methodDescription = this.findInstrumentedMethodInSuperClass(methodDescription.getDeclaringType().getSuperClass(), instrumentedMethod)) != null);
        Class<? extends DefaultValueProvider> defaultValueProvider = annotationValueExtractor.defaultValueProvider();
        try {
            return defaultValueProvider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getDefaultValue();
        }
        catch (Exception e) {
            logger.error(String.format("Failed to obtain default value from %s, used by %s#%s on method %s", defaultValueProvider.getName(), annotationValueExtractor.annotationClassName(), annotationValueExtractor.method(), instrumentedMethod), e);
            return null;
        }
    }

    @Nullable
    private MethodDescription findInstrumentedMethodInSuperClass(@Nullable TypeDescription.Generic superClass, MethodDescription instrumentedMethod) {
        if (superClass == null) {
            return null;
        }
        for (MethodDescription methodDescription : superClass.getDeclaredMethods()) {
            if (!instrumentedMethod.getInternalName().equals(methodDescription.getInternalName()) || !instrumentedMethod.getParameters().asTypeList().asErasures().equals(methodDescription.getParameters().asTypeList().asErasures())) continue;
            return methodDescription;
        }
        return null;
    }

    public static class TrueDefaultValueProvider
    implements DefaultValueProvider {
        @Override
        @Nullable
        public Object getDefaultValue() {
            return Boolean.TRUE;
        }
    }

    public static class NullDefaultValueProvider
    implements DefaultValueProvider {
        @Override
        public Object getDefaultValue() {
            return null;
        }
    }

    public static interface DefaultValueProvider {
        @Nullable
        public Object getDefaultValue();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AnnotationValueExtractor {
        public String annotationClassName();

        public String method();

        public Class<? extends DefaultValueProvider> defaultValueProvider() default NullDefaultValueProvider.class;
    }
}

