/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.bytebuddy.MatcherTimer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class InstrumentationStats {
    private final Set<ElasticApmInstrumentation> allInstrumentations = new HashSet<ElasticApmInstrumentation>();
    private final ConcurrentMap<ElasticApmInstrumentation, Boolean> usedInstrumentations = new ConcurrentHashMap<ElasticApmInstrumentation, Boolean>();
    private final ConcurrentMap<String, MatcherTimer> matcherTimers = new ConcurrentHashMap<String, MatcherTimer>();
    private boolean measureMatching = false;

    void reset() {
        this.allInstrumentations.clear();
        this.usedInstrumentations.clear();
        this.matcherTimers.clear();
        this.measureMatching = false;
    }

    void addInstrumentation(ElasticApmInstrumentation instrumentation) {
        this.allInstrumentations.add(instrumentation);
    }

    void addUsedInstrumentation(ElasticApmInstrumentation instrumentation) {
        this.usedInstrumentations.put(instrumentation, Boolean.TRUE);
    }

    public Collection<String> getUsedInstrumentationGroups() {
        TreeSet<String> usedInstrumentationGroups = new TreeSet<String>();
        for (ElasticApmInstrumentation instrumentation : this.usedInstrumentations.keySet()) {
            usedInstrumentationGroups.addAll(instrumentation.getInstrumentationGroupNames());
        }
        for (ElasticApmInstrumentation instrumentation : this.allInstrumentations) {
            Collection<String> instrumentationGroups;
            if (this.usedInstrumentations.containsKey(instrumentation) || usedInstrumentationGroups.containsAll(instrumentationGroups = instrumentation.getInstrumentationGroupNames())) continue;
            usedInstrumentationGroups.removeAll(instrumentationGroups);
        }
        return usedInstrumentationGroups;
    }

    MatcherTimer getOrCreateTimer(Class<? extends ElasticApmInstrumentation> adviceClass) {
        String name = adviceClass.getName();
        MatcherTimer timer = (MatcherTimer)this.matcherTimers.get(name);
        if (timer == null) {
            this.matcherTimers.putIfAbsent(name, new MatcherTimer(name));
            return (MatcherTimer)this.matcherTimers.get(name);
        }
        return timer;
    }

    long getTotalMatcherTime() {
        long totalTime = 0L;
        for (MatcherTimer value : this.matcherTimers.values()) {
            totalTime += value.getTotalTime();
        }
        return totalTime;
    }

    Collection<MatcherTimer> getMatcherTimers() {
        return this.matcherTimers.values();
    }

    public void setMeasureMatching(boolean measureMatching) {
        this.measureMatching = measureMatching;
    }

    public boolean shouldMeasureMatching() {
        return this.measureMatching;
    }
}

