/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.classloading.IndyPluginClassLoader;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.pool.TypePool;

public class IndyPluginClassLoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(IndyPluginClassLoaderFactory.class);
    private static final Map<ClassLoader, Map<Collection<String>, WeakReference<ClassLoader>>> alreadyInjected = new WeakHashMap<ClassLoader, Map<Collection<String>, WeakReference<ClassLoader>>>();

    public static synchronized ClassLoader getOrCreatePluginClassLoader(@Nullable ClassLoader targetClassLoader, List<String> classesToInject, ClassLoader agentClassLoader, ClassFileLocator classFileLocator, ElementMatcher<? super TypeDescription> exclusionMatcher) throws Exception {
        classesToInject = new ArrayList<String>(classesToInject);
        Map<Collection<String>, WeakReference<ClassLoader>> injectedClasses = IndyPluginClassLoaderFactory.getOrCreateInjectedClasses(targetClassLoader);
        if (injectedClasses.containsKey(classesToInject)) {
            ClassLoader pluginClassLoader = (ClassLoader)injectedClasses.get(classesToInject).get();
            if (pluginClassLoader == null) {
                injectedClasses.remove(classesToInject);
            } else {
                return pluginClassLoader;
            }
        }
        ArrayList<String> classesToInjectCopy = new ArrayList<String>(classesToInject.size());
        TypePool.Default.WithLazyResolution pool = new TypePool.Default.WithLazyResolution(TypePool.CacheProvider.NoOp.INSTANCE, classFileLocator, TypePool.Default.ReaderMode.FAST);
        for (String className : classesToInject) {
            boolean excluded;
            try {
                excluded = exclusionMatcher.matches(pool.describe(className).resolve());
            }
            catch (Exception e) {
                excluded = false;
            }
            if (excluded) continue;
            classesToInjectCopy.add(className);
        }
        logger.debug("Creating plugin class loader for {} containing {}", (Object)targetClassLoader, (Object)classesToInjectCopy);
        Map<String, byte[]> typeDefinitions = IndyPluginClassLoaderFactory.getTypeDefinitions(classesToInjectCopy, classFileLocator);
        IndyPluginClassLoader pluginClassLoader = new IndyPluginClassLoader(targetClassLoader, agentClassLoader, typeDefinitions);
        injectedClasses.put(classesToInject, new WeakReference<IndyPluginClassLoader>(pluginClassLoader));
        return pluginClassLoader;
    }

    private static Map<Collection<String>, WeakReference<ClassLoader>> getOrCreateInjectedClasses(@Nullable ClassLoader targetClassLoader) {
        Map<Collection<String>, WeakReference<ClassLoader>> injectedClasses = alreadyInjected.get(targetClassLoader);
        if (injectedClasses == null) {
            injectedClasses = new HashMap<Collection<String>, WeakReference<ClassLoader>>();
            alreadyInjected.put(targetClassLoader, injectedClasses);
        }
        return injectedClasses;
    }

    public static synchronized void clear() {
        alreadyInjected.clear();
    }

    private static Map<String, byte[]> getTypeDefinitions(List<String> helperClassNames, ClassFileLocator classFileLocator) throws IOException {
        HashMap<String, byte[]> typeDefinitions = new HashMap<String, byte[]>();
        for (String helperName : helperClassNames) {
            byte[] classBytes = classFileLocator.locate(helperName).resolve();
            typeDefinitions.put(helperName, classBytes);
        }
        return typeDefinitions;
    }
}

