/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.IndyBootstrap;
import co.elastic.apm.agent.bci.IndyPluginClassLoaderFactory;
import co.elastic.apm.agent.bci.InstrumentationStats;
import co.elastic.apm.agent.bci.PluginClassLoaderRootPackageCustomizer;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.ClassLoaderNameMatcher;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.ErrorLoggingListener;
import co.elastic.apm.agent.bci.bytebuddy.FailSafeDeclaredMethodsCompiler;
import co.elastic.apm.agent.bci.bytebuddy.InstallationListenerImpl;
import co.elastic.apm.agent.bci.bytebuddy.Instrumented;
import co.elastic.apm.agent.bci.bytebuddy.LruTypePoolCache;
import co.elastic.apm.agent.bci.bytebuddy.MinimumClassFileVersionValidator;
import co.elastic.apm.agent.bci.bytebuddy.NonInstrumented;
import co.elastic.apm.agent.bci.bytebuddy.PatchBytecodeVersionTo51Transformer;
import co.elastic.apm.agent.bci.bytebuddy.RootPackageCustomLocator;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.bci.classloading.ExternalPluginClassLoader;
import co.elastic.apm.agent.common.ThreadUtils;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.ElasticApmTracerBuilder;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.matcher.MethodMatcher;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import co.elastic.apm.agent.tracemethods.TraceMethodInstrumentation;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import co.elastic.apm.agent.util.ExecutorUtils;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.TypeConstantAdjustment;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.source.ConfigurationSource;

public class ElasticApmAgent {
    @Nullable
    private static Logger logger;
    private static boolean ancientBytecodeInstrumentationEnabled;
    private static final InstrumentationStats instrumentationStats;
    @Nullable
    private static Instrumentation instrumentation;
    @Nullable
    private static ResettableClassFileTransformer resettableClassFileTransformer;
    private static final List<ResettableClassFileTransformer> dynamicClassFileTransformers;
    private static final WeakMap<Class<?>, Set<Collection<Class<? extends ElasticApmInstrumentation>>>> dynamicallyInstrumentedClasses;
    @Nullable
    private static File agentJarFile;
    private static final ConcurrentMap<String, ClassLoader> adviceClassName2instrumentationClassLoader;
    private static final ConcurrentMap<String, Collection<String>> pluginPackages2pluginClassLoaderRootPackages;

    public static void initialize(@Nullable String agentArguments, Instrumentation instrumentation, File agentJarFile, boolean premain) {
        ElasticApmAgent.agentJarFile = agentJarFile;
        List<ConfigurationSource> configSources = ElasticApmTracerBuilder.getConfigSources(agentArguments, premain);
        for (ConfigurationSource configSource : configSources) {
            String enabled = configSource.getValue("enabled");
            if (enabled == null || Boolean.parseBoolean(enabled)) continue;
            return;
        }
        ElasticApmTracer tracer = new ElasticApmTracerBuilder(configSources).build();
        ElasticApmAgent.initInstrumentation(tracer, instrumentation, premain);
        tracer.start(premain);
    }

    public static void initInstrumentation(ElasticApmTracer tracer, Instrumentation instrumentation) {
        ElasticApmAgent.initInstrumentation(tracer, instrumentation, false);
    }

    private static void initInstrumentation(ElasticApmTracer tracer, Instrumentation instrumentation, boolean premain) {
        if (!tracer.getConfig(CoreConfiguration.class).isEnabled()) {
            return;
        }
        GlobalTracer.init(tracer);
        ElasticApmAgent.initInstrumentation(tracer, instrumentation, ElasticApmAgent.loadInstrumentations(tracer), premain);
    }

    @Nonnull
    private static Iterable<ElasticApmInstrumentation> loadInstrumentations(ElasticApmTracer tracer) {
        ArrayList<ClassLoader> pluginClassLoaders = new ArrayList<ClassLoader>();
        pluginClassLoaders.add(PrivilegedActionUtils.getClassLoader(ElasticApmAgent.class));
        pluginClassLoaders.addAll(ElasticApmAgent.createExternalPluginClassLoaders(tracer.getConfig(CoreConfiguration.class).getPluginsDir()));
        List<ElasticApmInstrumentation> instrumentations = DependencyInjectingServiceLoader.load(ElasticApmInstrumentation.class, pluginClassLoaders, tracer);
        for (MethodMatcher traceMethod : tracer.getConfig(CoreConfiguration.class).getTraceMethods()) {
            instrumentations.add(new TraceMethodInstrumentation(tracer, traceMethod));
        }
        return instrumentations;
    }

    private static Collection<? extends ClassLoader> createExternalPluginClassLoaders(@Nullable String pluginsDirString) {
        Logger logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        if (pluginsDirString == null) {
            logger.debug("No plugins dir");
            return Collections.emptyList();
        }
        File pluginsDir = new File(pluginsDirString);
        if (!pluginsDir.exists()) {
            logger.debug("Plugins dir does not exist: {}", (Object)pluginsDirString);
            return Collections.emptyList();
        }
        File[] pluginJars = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (pluginJars == null) {
            logger.info("Invalid plugins dir {}", (Object)pluginsDirString);
            return Collections.emptyList();
        }
        ArrayList<ExternalPluginClassLoader> result = new ArrayList<ExternalPluginClassLoader>(pluginJars.length);
        for (File pluginJar : pluginJars) {
            logger.info("Loading plugin {}", (Object)pluginJar.getName());
            try {
                result.add(new ExternalPluginClassLoader(pluginJar, PrivilegedActionUtils.getClassLoader(ElasticApmAgent.class)));
            }
            catch (Exception e) {
                logger.error("Error loading external plugin", e);
            }
        }
        return result;
    }

    public static synchronized void initInstrumentation(ElasticApmTracer tracer, Instrumentation instrumentation, Iterable<ElasticApmInstrumentation> instrumentations) {
        GlobalTracer.init(tracer);
        ElasticApmAgent.initInstrumentation(tracer, instrumentation, instrumentations, false);
    }

    private static synchronized void initInstrumentation(final ElasticApmTracer tracer, Instrumentation instrumentation, Iterable<ElasticApmInstrumentation> instrumentations, boolean premain) {
        CoreConfiguration coreConfig = tracer.getConfig(CoreConfiguration.class);
        if (!coreConfig.isEnabled()) {
            return;
        }
        ancientBytecodeInstrumentationEnabled = coreConfig.isInstrumentAncientBytecode();
        String bytecodeDumpPath = coreConfig.getBytecodeDumpPath();
        if (bytecodeDumpPath != null && !(bytecodeDumpPath = bytecodeDumpPath.trim()).isEmpty()) {
            try {
                File bytecodeDumpDir = Paths.get(bytecodeDumpPath, new String[0]).toFile();
                if (!bytecodeDumpDir.exists()) {
                    bytecodeDumpDir.mkdirs();
                }
                System.setProperty("net.bytebuddy.dump", bytecodeDumpDir.getPath());
            }
            catch (Exception e) {
                System.err.println("[elastic-apm-agent] WARN Failed to create directory to dump instrumented bytecode: " + e.getMessage());
            }
        }
        List<PluginClassLoaderRootPackageCustomizer> rootPackageCustomizers = DependencyInjectingServiceLoader.load(PluginClassLoaderRootPackageCustomizer.class, ElasticApmAgent.getAgentClassLoader());
        for (PluginClassLoaderRootPackageCustomizer rootPackageCustomizer : rootPackageCustomizers) {
            Collection previous = pluginPackages2pluginClassLoaderRootPackages.put(rootPackageCustomizer.getPluginPackage(), Collections.unmodifiableList(new ArrayList<String>(rootPackageCustomizer.pluginClassLoaderRootPackages())));
            if (previous == null) continue;
            throw new IllegalStateException("Only one PluginClassLoaderRootPackageCustomizer is allowed per plugin package: " + rootPackageCustomizer.getPluginPackage());
        }
        for (ElasticApmInstrumentation apmInstrumentation : instrumentations) {
            ElasticApmAgent.mapInstrumentationCL2adviceClassName(apmInstrumentation.getAdviceClassName(), PrivilegedActionUtils.getClassLoader(apmInstrumentation.getClass()));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(ThreadUtils.addElasticApmThreadPrefix("init-instrumentation-shutdown-hook")){

            @Override
            public void run() {
                tracer.stop();
            }
        });
        Logger logger = ElasticApmAgent.getLogger();
        if (ElasticApmAgent.instrumentation != null) {
            logger.warn("Instrumentation has already been initialized");
            return;
        }
        AgentBuilder agentBuilder = ElasticApmAgent.initAgentBuilder(tracer, instrumentation, instrumentations, logger, AgentBuilder.DescriptionStrategy.Default.POOL_ONLY, premain);
        if (tracer.getConfig(CoreConfiguration.class).shouldWarmupByteBuddy()) {
            agentBuilder = agentBuilder.with(new InstallationListenerImpl()).warmUp(NonInstrumented.class).warmUp(Instrumented.class);
        }
        resettableClassFileTransformer = agentBuilder.installOn(ElasticApmAgent.instrumentation);
        for (ConfigurationOption<?> instrumentationOption : coreConfig.getInstrumentationOptions()) {
            instrumentationOption.addChangeListener(new ConfigurationOption.ChangeListener(){

                public void onChange(ConfigurationOption configurationOption, Object oldValue, Object newValue) {
                    ElasticApmAgent.reInitInstrumentation();
                }
            });
        }
    }

    public static synchronized Future<?> reInitInstrumentation() {
        final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();
        if (instrumentation == null) {
            throw new IllegalStateException("Can't re-init agent before it has been initialized");
        }
        ThreadPoolExecutor executor = ExecutorUtils.createSingleThreadDaemonPool("apm-reinit", 1);
        try {
            Future<?> future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    ElasticApmAgent.doReInitInstrumentation(ElasticApmAgent.loadInstrumentations(tracer));
                }
            });
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    static synchronized void doReInitInstrumentation(Iterable<ElasticApmInstrumentation> instrumentations) {
        Logger logger = ElasticApmAgent.getLogger();
        logger.info("Re initializing instrumentation");
        AgentBuilder agentBuilder = ElasticApmAgent.initAgentBuilder(GlobalTracer.requireTracerImpl(), instrumentation, instrumentations, logger, AgentBuilder.DescriptionStrategy.Default.POOL_ONLY, false);
        resettableClassFileTransformer = agentBuilder.patchOn(instrumentation, resettableClassFileTransformer);
    }

    private static AgentBuilder initAgentBuilder(ElasticApmTracer tracer, Instrumentation instrumentation, Iterable<ElasticApmInstrumentation> instrumentations, Logger logger, AgentBuilder.DescriptionStrategy descriptionStrategy, boolean premain) {
        CoreConfiguration coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        ElasticApmAgent.instrumentation = instrumentation;
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(logger.isDebugEnabled())).with(FailSafeDeclaredMethodsCompiler.INSTANCE);
        AgentBuilder agentBuilder = ElasticApmAgent.getAgentBuilder(byteBuddy, coreConfiguration, logger, descriptionStrategy, premain, coreConfiguration.isTypePoolCacheEnabled());
        int numberOfAdvices = 0;
        for (ElasticApmInstrumentation advice : instrumentations) {
            if (ElasticApmAgent.isIncluded(advice, coreConfiguration)) {
                instrumentationStats.addInstrumentation(advice);
                try {
                    agentBuilder = ElasticApmAgent.applyAdvice(tracer, agentBuilder, advice, advice.getTypeMatcher());
                    ++numberOfAdvices;
                    continue;
                }
                catch (Exception e) {
                    logger.error("Exception occurred while applying instrumentation {}", (Object)advice.getClass().getName(), (Object)e);
                    assert (false);
                    continue;
                }
            }
            logger.debug("Not applying excluded instrumentation {}", (Object)advice.getClass().getName());
        }
        logger.debug("Applied {} advices", (Object)numberOfAdvices);
        return agentBuilder;
    }

    private static boolean isIncluded(ElasticApmInstrumentation advice, CoreConfiguration coreConfiguration) {
        return ElasticApmAgent.isInstrumentationEnabled(advice, coreConfiguration) && coreConfiguration.isInstrumentationEnabled(advice.getInstrumentationGroupNames());
    }

    private static boolean isInstrumentationEnabled(ElasticApmInstrumentation advice, CoreConfiguration coreConfiguration) {
        return advice.includeWhenInstrumentationIsDisabled() || coreConfiguration.isInstrument();
    }

    private static AgentBuilder applyAdvice(ElasticApmTracer tracer, AgentBuilder agentBuilder, final ElasticApmInstrumentation instrumentation, final ElementMatcher<? super TypeDescription> typeMatcher) {
        final Logger logger = ElasticApmAgent.getLogger();
        logger.debug("Applying instrumentation {}", (Object)instrumentation.getClass().getName());
        final boolean classLoadingMatchingPreFilter = tracer.getConfig(CoreConfiguration.class).isClassLoadingMatchingPreFilter();
        final boolean typeMatchingWithNamePreFilter = tracer.getConfig(CoreConfiguration.class).isTypeMatchingWithNamePreFilter();
        final ElementMatcher.Junction<ClassLoader> classLoaderMatcher = instrumentation.getClassLoaderMatcher();
        final ElementMatcher<? super NamedElement> typeMatcherPreFilter = instrumentation.getTypeMatcherPreFilter();
        final ElementMatcher.Junction<ProtectionDomain> versionPostFilter = instrumentation.getProtectionDomainPostFilter();
        ElementMatcher.Junction.Conjunction methodMatcher = new ElementMatcher.Junction.Conjunction(instrumentation.getMethodMatcher(), ElementMatchers.not(ElementMatchers.isAbstract()));
        final AgentBuilder.RawMatcher matcher = new AgentBuilder.RawMatcher(){

            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                boolean typeMatches;
                if (classLoadingMatchingPreFilter && !classLoaderMatcher.matches(classLoader)) {
                    return false;
                }
                if (typeMatchingWithNamePreFilter && !typeMatcherPreFilter.matches(typeDescription)) {
                    return false;
                }
                try {
                    typeMatches = typeMatcher.matches(typeDescription) && versionPostFilter.matches(protectionDomain);
                }
                catch (Exception ignored) {
                    typeMatches = false;
                }
                if (typeMatches) {
                    logger.debug("Type match for instrumentation {}: {} matches {}", instrumentation.getClass().getSimpleName(), typeMatcher, typeDescription);
                    try {
                        instrumentation.onTypeMatch(typeDescription, classLoader, protectionDomain, classBeingRedefined);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                    if (logger.isTraceEnabled()) {
                        ElasticApmAgent.logClassLoaderHierarchy(classLoader, logger, instrumentation);
                    }
                }
                return typeMatches;
            }
        };
        AgentBuilder.RawMatcher statsCollectingMatcher = new AgentBuilder.RawMatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                long start = System.nanoTime();
                try {
                    boolean bl = matcher.matches(typeDescription, classLoader, module, classBeingRedefined, protectionDomain);
                    return bl;
                }
                finally {
                    instrumentationStats.getOrCreateTimer(instrumentation.getClass()).addTypeMatchingDuration(System.nanoTime() - start);
                }
            }
        };
        return agentBuilder.type(instrumentationStats.shouldMeasureMatching() ? statsCollectingMatcher : matcher).transform(new PatchBytecodeVersionTo51Transformer()).transform(ElasticApmAgent.getTransformer(instrumentation, logger, methodMatcher)).transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, ProtectionDomain protectionDomain) {
                if (!ancientBytecodeInstrumentationEnabled) {
                    builder = builder.visit(MinimumClassFileVersionValidator.V1_4);
                }
                return builder.visit(TypeConstantAdjustment.INSTANCE);
            }
        });
    }

    private static Logger getLogger() {
        if (logger == null) {
            GlobalTracer.requireTracerImpl();
            logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        }
        return logger;
    }

    private static AgentBuilder.Transformer.ForAdvice getTransformer(final ElasticApmInstrumentation instrumentation, final Logger logger, final ElementMatcher<? super MethodDescription> methodMatcher) {
        boolean validate = false;
        if (!$assertionsDisabled) {
            validate = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (validate) {
            ElasticApmAgent.validateAdvice(instrumentation);
        }
        Advice.WithCustomMapping withCustomMapping = Advice.withCustomMapping().with(new Advice.AssignReturned.Factory().withSuppressed(ClassCastException.class)).bind(new SimpleMethodSignatureOffsetMappingFactory()).bind(new AnnotationValueOffsetMappingFactory());
        Advice.OffsetMapping.Factory<?> offsetMapping = instrumentation.getOffsetMapping();
        if (offsetMapping != null) {
            withCustomMapping = withCustomMapping.bind(offsetMapping);
        }
        withCustomMapping = withCustomMapping.bootstrap(IndyBootstrap.getIndyBootstrapMethod(logger));
        final ElementMatcher<MethodDescription> matcher = new ElementMatcher<MethodDescription>(){

            @Override
            public boolean matches(MethodDescription target) {
                boolean matches;
                try {
                    matches = methodMatcher.matches(target);
                }
                catch (Exception ignored) {
                    matches = false;
                }
                if (matches) {
                    logger.debug("Method match for instrumentation {}: {} matches {}", instrumentation.getClass().getSimpleName(), methodMatcher, target);
                    instrumentationStats.addUsedInstrumentation(instrumentation);
                }
                return matches;
            }
        };
        ElementMatcher<MethodDescription> statsCollectingMatcher = new ElementMatcher<MethodDescription>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matches(MethodDescription target) {
                long start = System.nanoTime();
                try {
                    boolean bl = matcher.matches(target);
                    return bl;
                }
                finally {
                    instrumentationStats.getOrCreateTimer(instrumentation.getClass()).addMethodMatchingDuration(System.nanoTime() - start);
                }
            }
        };
        return new AgentBuilder.Transformer.ForAdvice(withCustomMapping).advice((ElementMatcher<? super MethodDescription>)(instrumentationStats.shouldMeasureMatching() ? statsCollectingMatcher : matcher), instrumentation.getAdviceClassName()).include(ClassLoader.getSystemClassLoader(), PrivilegedActionUtils.getClassLoader(instrumentation.getClass())).withExceptionHandler(Advice.ExceptionHandler.Default.PRINTING);
    }

    public static void validateAdvice(ElasticApmInstrumentation instrumentation) {
        TypePool.Default.WithLazyResolution pool;
        TypeDescription typeDescription;
        int adviceModifiers;
        String adviceClassName = instrumentation.getAdviceClassName();
        if (instrumentation.getClass().getName().equals(adviceClassName)) {
            throw new IllegalStateException("The advice must be declared in a separate class: " + adviceClassName);
        }
        ClassLoader adviceClassLoader = PrivilegedActionUtils.getClassLoader(instrumentation.getClass());
        if (adviceClassLoader == null) {
            adviceClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (!Modifier.isPublic(adviceModifiers = (typeDescription = (pool = new TypePool.Default.WithLazyResolution(TypePool.CacheProvider.NoOp.INSTANCE, ClassFileLocator.ForClassLoader.of(adviceClassLoader), TypePool.Default.ReaderMode.FAST)).describe(adviceClassName).resolve()).getModifiers())) {
            throw new IllegalStateException(String.format("advice class %s should be public", adviceClassName));
        }
        for (MethodDescription.InDefinedShape enterAdvice : (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.isAnnotatedWith(Advice.OnMethodEnter.class)))) {
            ElasticApmAgent.validateAdviceReturnAndParameterTypes(enterAdvice, adviceClassName);
            ElasticApmAgent.validateLegacyAssignToIsNotUsed(enterAdvice);
            for (AnnotationDescription enter : (AnnotationList)enterAdvice.getDeclaredAnnotations().filter(ElementMatchers.annotationType(Advice.OnMethodEnter.class))) {
                ElasticApmAgent.checkInline(enterAdvice, adviceClassName, enter.prepare(Advice.OnMethodEnter.class).load().inline());
            }
        }
        for (MethodDescription.InDefinedShape exitAdvice : (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.isAnnotatedWith(Advice.OnMethodExit.class)))) {
            ElasticApmAgent.validateAdviceReturnAndParameterTypes(exitAdvice, adviceClassName);
            ElasticApmAgent.validateLegacyAssignToIsNotUsed(exitAdvice);
            if (exitAdvice.getReturnType().asRawType().getTypeName().startsWith("co.elastic.apm")) {
                throw new IllegalStateException("Advice return type must be visible from the bootstrap class loader and must not be an agent type.");
            }
            for (AnnotationDescription exit : (AnnotationList)exitAdvice.getDeclaredAnnotations().filter(ElementMatchers.annotationType(Advice.OnMethodExit.class))) {
                ElasticApmAgent.checkInline(exitAdvice, adviceClassName, exit.prepare(Advice.OnMethodExit.class).load().inline());
            }
        }
        if (!(adviceClassLoader instanceof ExternalPluginClassLoader) && !adviceClassName.startsWith("co.elastic.apm.agent.")) {
            throw new IllegalStateException(String.format("Invalid Advice class - %s - Indy-dispatched advice class must be in a sub-package of 'co.elastic.apm.agent'.", adviceClassName));
        }
    }

    private static void checkInline(MethodDescription.InDefinedShape advice, String adviceClassName, boolean isInline) {
        if (isInline) {
            throw new IllegalStateException(String.format("Indy-dispatched advice %s#%s has to be declared with inline=false", adviceClassName, advice.getName()));
        }
        if (!Modifier.isPublic(advice.getModifiers())) {
            throw new IllegalStateException(String.format("Indy-dispatched advice %s#%s has to be declared public", adviceClassName, advice.getName()));
        }
    }

    private static void validateLegacyAssignToIsNotUsed(MethodDescription.InDefinedShape advice) {
        boolean usesLegacyAssignToAnnotations;
        boolean bl = usesLegacyAssignToAnnotations = !((TypeList)advice.getDeclaredAnnotations().asTypeList().filter(ElementMatchers.nameStartsWith("co.elastic.apm.agent.sdk.advice.AssignTo"))).isEmpty();
        if (usesLegacyAssignToAnnotations) {
            throw new IllegalStateException("@AssignTo.* annotations have been removed in favor of Byte Buddy's @Advice.AssignReturned.* annotations");
        }
    }

    private static void validateAdviceReturnAndParameterTypes(MethodDescription.InDefinedShape advice, String adviceClass) {
        String adviceMethod = advice.getInternalName();
        try {
            ElasticApmAgent.checkNotAgentType(advice.getReturnType(), "return type", adviceClass, adviceMethod);
            for (ParameterDescription.InDefinedShape parameter : advice.getParameters()) {
                ElasticApmAgent.checkNotAgentType(parameter.getType(), "parameter", adviceClass, adviceMethod);
                AnnotationDescription.Loadable<Advice.Return> returnAnnotation = parameter.getDeclaredAnnotations().ofType(Advice.Return.class);
                if (returnAnnotation == null || returnAnnotation.load().readOnly()) continue;
                throw new IllegalStateException("Advice parameter must not use '@Advice.Return(readOnly=false)', use @Advice.AssignReturned.ToReturned instead");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("unable to validate advice defined in %s#%s", adviceClass, adviceMethod), e);
        }
    }

    private static void checkNotAgentType(TypeDescription.Generic type, String description, String adviceClass, String adviceMethod) {
        String name = type.asRawType().getTypeName();
        if (name.startsWith("co.elastic.apm")) {
            throw new IllegalStateException(String.format("Advice %s in %s#%s must not be an agent type: %s", description, adviceClass, adviceMethod, name));
        }
    }

    public static InstrumentationStats getInstrumentationStats() {
        return instrumentationStats;
    }

    private static void logClassLoaderHierarchy(@Nullable ClassLoader classLoader, Logger logger, ElasticApmInstrumentation advice) {
        logger.trace("Advice {} is loaded by {}", (Object)advice.getClass().getName(), (Object)PrivilegedActionUtils.getClassLoader(advice.getClass()));
        if (classLoader != null) {
            boolean canLoadAgent = false;
            try {
                classLoader.loadClass(advice.getClass().getName());
                canLoadAgent = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            logger.trace("{} can load advice ({}): {}", classLoader, advice.getClass().getName(), canLoadAgent);
            ElasticApmAgent.logClassLoaderHierarchy(classLoader.getParent(), logger, advice);
        } else {
            logger.trace("bootstrap classloader");
        }
    }

    public static synchronized void reset() {
        if (instrumentation == null) {
            return;
        }
        GlobalTracer.get().stop();
        GlobalTracer.setNoop();
        Exception exception = null;
        if (resettableClassFileTransformer != null) {
            try {
                resettableClassFileTransformer.reset(instrumentation, AgentBuilder.RedefinitionStrategy.RETRANSFORMATION);
            }
            catch (Exception e) {
                exception = e;
            }
            resettableClassFileTransformer = null;
        }
        dynamicallyInstrumentedClasses.clear();
        for (ResettableClassFileTransformer transformer : dynamicClassFileTransformers) {
            try {
                transformer.reset(instrumentation, AgentBuilder.RedefinitionStrategy.RETRANSFORMATION);
            }
            catch (Exception e) {
                if (exception != null) {
                    exception.addSuppressed(e);
                    continue;
                }
                exception = e;
            }
        }
        dynamicClassFileTransformers.clear();
        instrumentation = null;
        IndyPluginClassLoaderFactory.clear();
        adviceClassName2instrumentationClassLoader.clear();
        pluginPackages2pluginClassLoaderRootPackages.clear();
    }

    private static AgentBuilder getAgentBuilder(ByteBuddy byteBuddy, CoreConfiguration coreConfiguration, final Logger logger, AgentBuilder.DescriptionStrategy descriptionStrategy, boolean premain, boolean useTypePoolCache) {
        AgentBuilder.LocationStrategy locationStrategy = AgentBuilder.LocationStrategy.ForClassLoader.WEAK;
        if (agentJarFile != null) {
            try {
                locationStrategy = new AgentBuilder.LocationStrategy.Compound(new AgentBuilder.LocationStrategy.Simple(ClassFileLocator.ForJarFile.of(agentJarFile)), AgentBuilder.LocationStrategy.ForClassLoader.WEAK, new AgentBuilder.LocationStrategy.Simple(new RootPackageCustomLocator("java.", ClassFileLocator.ForClassLoader.ofBootLoader())));
            }
            catch (IOException e) {
                logger.warn("Failed to add ClassFileLocator for the agent jar. Some instrumentations may not work", e);
            }
        }
        return ((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)((AgentBuilder.Ignored)new AgentBuilder.Default(byteBuddy).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(premain ? AgentBuilder.RedefinitionStrategy.BatchAllocator.ForTotal.INSTANCE : AgentBuilder.RedefinitionStrategy.BatchAllocator.ForFixedSize.ofSize(100)).with(premain ? AgentBuilder.RedefinitionStrategy.Listener.NoOp.INSTANCE : AgentBuilder.RedefinitionStrategy.Listener.Pausing.of(100L, TimeUnit.MILLISECONDS)).with(new AgentBuilder.RedefinitionStrategy.Listener.Adapter(){

            @Override
            public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
                logger.warn("Error while redefining classes {}", (Object)throwable.getMessage());
                logger.debug(throwable.getMessage(), throwable);
                return super.onError(index, batch, throwable, types);
            }
        }).with(descriptionStrategy).with(locationStrategy).with(new ErrorLoggingListener()).with(useTypePoolCache ? new LruTypePoolCache(TypePool.Default.ReaderMode.FAST).scheduleEntryEviction() : AgentBuilder.PoolStrategy.Default.FAST).ignore(ElementMatchers.any(), ClassLoaderNameMatcher.isReflectionClassLoader()).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithName("org.codehaus.groovy.runtime.callsite.CallSiteClassLoader"))).or(ElementMatchers.nameStartsWith("org.aspectj."))).or(ElementMatchers.nameStartsWith("org.groovy."))).or(ElementMatchers.nameStartsWith("com.p6spy."))).or(ElementMatchers.nameStartsWith("net.bytebuddy."))).or(ElementMatchers.nameStartsWith("org.stagemonitor."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("com.newrelic."))).or(ElementMatchers.nameStartsWith("com.newrelic."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("com.nr.agent."))).or(ElementMatchers.nameStartsWith("com.nr.agent."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("com.dynatrace."))).or(ElementMatchers.nameStartsWith("com.dynatrace."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("com.singularity"))).or(ElementMatchers.nameStartsWith("com.singularity."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("com.appdynamics."))).or(ElementMatchers.nameStartsWith("com.appdynamics."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("com.instana."))).or(ElementMatchers.nameStartsWith("com.instana."))).or(ElementMatchers.any(), ClassLoaderNameMatcher.classLoaderWithNamePrefix("datadog."))).or(ElementMatchers.nameStartsWith("datadog."))).or(ElementMatchers.nameStartsWith("org.glowroot."))).or(ElementMatchers.nameStartsWith("com.compuware."))).or(ElementMatchers.nameStartsWith("io.sqreen."))).or(ElementMatchers.nameStartsWith("com.contrastsecurity."))).or(ElementMatchers.nameContains("javassist"))).or(ElementMatchers.nameContains(".asm."))).or(CustomElementMatchers.anyMatch(coreConfiguration.getDefaultClassesExcludedFromInstrumentation()))).or(CustomElementMatchers.anyMatch(coreConfiguration.getClassesExcludedFromInstrumentation()))).disableClassFormatChanges();
    }

    @Nullable
    public static String getAgentHome() {
        return agentJarFile == null ? null : agentJarFile.getParent();
    }

    @Nullable
    public static File getAgentJarFile() {
        return agentJarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureInstrumented(final Class<?> classToInstrument, final Collection<Class<? extends ElasticApmInstrumentation>> instrumentationClasses) {
        Set<Collection<Class<? extends ElasticApmInstrumentation>>> appliedInstrumentations = ElasticApmAgent.getOrCreate(classToInstrument);
        if (appliedInstrumentations.contains(instrumentationClasses)) return;
        Class<ElasticApmAgent> clazz = ElasticApmAgent.class;
        synchronized (ElasticApmAgent.class) {
            final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();
            if (instrumentation == null) {
                throw new IllegalStateException("Agent is not initialized");
            }
            final Set<Collection<Class<? extends ElasticApmInstrumentation>>> updatedAppliedInstrumentations = dynamicallyInstrumentedClasses.get(classToInstrument);
            if (updatedAppliedInstrumentations.contains(instrumentationClasses)) return;
            if (System.getSecurityManager() == null) {
                ElasticApmAgent.applyInstrumentation(classToInstrument, instrumentationClasses, updatedAppliedInstrumentations, tracer);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ElasticApmAgent.applyInstrumentation(classToInstrument, instrumentationClasses, updatedAppliedInstrumentations, tracer);
                        return null;
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void applyInstrumentation(Class<?> classToInstrument, Collection<Class<? extends ElasticApmInstrumentation>> instrumentationClasses, Set<Collection<Class<? extends ElasticApmInstrumentation>>> appliedInstrumentations, ElasticApmTracer tracer) {
        appliedInstrumentations = new HashSet<Collection<Class<? extends ElasticApmInstrumentation>>>(appliedInstrumentations);
        appliedInstrumentations.add(instrumentationClasses);
        appliedInstrumentations = Collections.unmodifiableSet(appliedInstrumentations);
        dynamicallyInstrumentedClasses.put(classToInstrument, appliedInstrumentations);
        CoreConfiguration config = tracer.getConfig(CoreConfiguration.class);
        Logger logger = LoggerFactory.getLogger(ElasticApmAgent.class);
        ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.of(logger.isDebugEnabled())).with(FailSafeDeclaredMethodsCompiler.INSTANCE);
        AgentBuilder agentBuilder = ElasticApmAgent.getAgentBuilder(byteBuddy, config, logger, AgentBuilder.DescriptionStrategy.Default.POOL_ONLY, false, false);
        for (Class<? extends ElasticApmInstrumentation> instrumentationClass : instrumentationClasses) {
            ElasticApmInstrumentation apmInstrumentation = ElasticApmAgent.instantiate(instrumentationClass);
            ElasticApmAgent.mapInstrumentationCL2adviceClassName(apmInstrumentation.getAdviceClassName(), PrivilegedActionUtils.getClassLoader(instrumentationClass));
            ElementMatcher.Junction<? super TypeDescription> typeMatcher = ElasticApmAgent.getTypeMatcher(classToInstrument, apmInstrumentation.getMethodMatcher(), ElementMatchers.none());
            if (typeMatcher == null || !ElasticApmAgent.isIncluded(apmInstrumentation, config)) continue;
            agentBuilder = ElasticApmAgent.applyAdvice(tracer, agentBuilder, apmInstrumentation, typeMatcher.and(apmInstrumentation.getTypeMatcher()));
        }
        dynamicClassFileTransformers.add(agentBuilder.installOn(instrumentation));
    }

    public static void mapInstrumentationCL2adviceClassName(String adviceClassName, ClassLoader instrumentationClassLoader) {
        adviceClassName2instrumentationClassLoader.put(adviceClassName, instrumentationClassLoader);
    }

    private static Set<Collection<Class<? extends ElasticApmInstrumentation>>> getOrCreate(Class<?> classToInstrument) {
        Set<Collection<Class<? extends ElasticApmInstrumentation>>> racy;
        Set<Collection<Class<? extends ElasticApmInstrumentation>>> instrumentedClasses = dynamicallyInstrumentedClasses.get(classToInstrument);
        if (instrumentedClasses == null && (racy = dynamicallyInstrumentedClasses.putIfAbsent(classToInstrument, instrumentedClasses = new HashSet<Collection<Class<? extends ElasticApmInstrumentation>>>())) != null) {
            instrumentedClasses = racy;
        }
        return instrumentedClasses;
    }

    @Nullable
    private static ElementMatcher.Junction<? super TypeDescription> getTypeMatcher(@Nullable Class<?> classToInstrument, ElementMatcher<? super MethodDescription> methodMatcher, ElementMatcher.Junction<? super TypeDescription> typeMatcher) {
        if (classToInstrument == null) {
            return typeMatcher;
        }
        if (ElasticApmAgent.matches(classToInstrument, methodMatcher)) {
            typeMatcher = ElementMatchers.is(classToInstrument).or(typeMatcher);
        }
        return ElasticApmAgent.getTypeMatcher(classToInstrument.getSuperclass(), methodMatcher, typeMatcher);
    }

    private static boolean matches(Class<?> classToInstrument, ElementMatcher<? super MethodDescription> methodMatcher) {
        return !((MethodList)TypeDescription.ForLoadedType.of(classToInstrument).getDeclaredMethods().filter(methodMatcher)).isEmpty();
    }

    private static ElasticApmInstrumentation instantiate(Class<? extends ElasticApmInstrumentation> instrumentation) {
        ElasticApmInstrumentation instance = ElasticApmAgent.tryInstantiate(instrumentation, false);
        if (instance == null) {
            instance = ElasticApmAgent.tryInstantiate(instrumentation, true);
        }
        if (instance == null) {
            throw new IllegalArgumentException("unable to find matching public constructor for instrumentation " + instrumentation);
        }
        return instance;
    }

    @Nullable
    private static ElasticApmInstrumentation tryInstantiate(Class<? extends ElasticApmInstrumentation> instrumentation, boolean withTracer) {
        Constructor<? extends ElasticApmInstrumentation> constructor = null;
        try {
            constructor = withTracer ? instrumentation.getConstructor(ElasticApmTracer.class) : instrumentation.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ElasticApmInstrumentation instance = null;
        if (constructor != null) {
            try {
                instance = withTracer ? constructor.newInstance(GlobalTracer.requireTracerImpl()) : constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return instance;
    }

    public static ClassLoader getAgentClassLoader() {
        ClassLoader agentClassLoader = PrivilegedActionUtils.getClassLoader(ElasticApmAgent.class);
        if (agentClassLoader == null) {
            throw new IllegalStateException("Agent is loaded from bootstrap class loader as opposed to the dedicated agent class loader");
        }
        return agentClassLoader;
    }

    public static ClassLoader getInstrumentationClassLoader(String adviceClass) {
        ClassLoader classLoader = (ClassLoader)adviceClassName2instrumentationClassLoader.get(adviceClass);
        if (classLoader == null) {
            throw new IllegalStateException("There's no mapping for key " + adviceClass);
        }
        return classLoader;
    }

    public static Collection<String> getPluginClassLoaderRootPackages(String pluginPackage) {
        Collection pluginPackages = (Collection)pluginPackages2pluginClassLoaderRootPackages.get(pluginPackage);
        if (pluginPackages != null) {
            return pluginPackages;
        }
        return Collections.singleton(pluginPackage);
    }

    static {
        instrumentationStats = new InstrumentationStats();
        dynamicClassFileTransformers = new ArrayList<ResettableClassFileTransformer>();
        dynamicallyInstrumentedClasses = WeakConcurrent.buildMap();
        adviceClassName2instrumentationClassLoader = new ConcurrentHashMap<String, ClassLoader>();
        pluginPackages2pluginClassLoaderRootPackages = new ConcurrentHashMap<String, Collection<String>>();
    }
}

