/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2.helper.sqs.wrapper;

import co.elastic.apm.agent.awssdk.common.AbstractMessageListWrapper;
import co.elastic.apm.agent.awssdk.v2.helper.SQSHelper;
import co.elastic.apm.agent.awssdk.v2.helper.SdkV2DataSource;
import co.elastic.apm.agent.awssdk.v2.helper.sqs.wrapper.MessageIteratorWrapper;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

public class MessageListWrapper
extends AbstractMessageListWrapper<Message> {
    public static final CallDepth jmsReceiveMessageCallDepth = CallDepth.get(MessageListWrapper.class);
    private static final WeakMap<ReceiveMessageResponse, List<Message>> sqsResponseToWrappedMessageListMap = WeakConcurrent.buildMap();

    public static void registerWrapperListForResponse(@Nullable SdkRequest sdkRequest, @Nullable SdkResponse sdkResponse, ElasticApmTracer tracer) {
        if (sdkResponse instanceof ReceiveMessageResponse && sdkRequest instanceof ReceiveMessageRequest) {
            String queueName = SdkV2DataSource.getInstance().getFieldValue("QueueName", sdkRequest);
            ReceiveMessageResponse receiveMessageResponse = (ReceiveMessageResponse)sdkResponse;
            if (!jmsReceiveMessageCallDepth.isNestedCallAndIncrement() && tracer.isRunning() && queueName != null && !WildcardMatcher.isAnyMatch(tracer.getConfig(MessagingConfiguration.class).getIgnoreMessageQueues(), queueName)) {
                sqsResponseToWrappedMessageListMap.put(receiveMessageResponse, new MessageListWrapper(receiveMessageResponse.messages(), tracer, queueName));
            }
            jmsReceiveMessageCallDepth.decrement();
        }
    }

    @Nullable
    public static List<Message> getMessagesList(ReceiveMessageResponse response) {
        if (!sqsResponseToWrappedMessageListMap.containsKey(response)) {
            return null;
        }
        return sqsResponseToWrappedMessageListMap.get(response);
    }

    public MessageListWrapper(List<Message> delegate, ElasticApmTracer tracer, String queueName) {
        super(delegate, tracer, queueName, SQSHelper.getInstance(), SQSHelper.getInstance());
    }

    @Override
    public Iterator<Message> iterator() {
        return new MessageIteratorWrapper(this.delegate.iterator(), this.tracer, this.queueName);
    }

    @Override
    public List<Message> subList(int fromIndex, int toIndex) {
        return new MessageListWrapper(this.delegate.subList(fromIndex, toIndex), this.tracer, this.queueName);
    }
}

