/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2.helper;

import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import javax.annotation.Nullable;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.regions.Region;

public class SdkV2DataSource
extends IAwsSdkDataSource<SdkRequest, ExecutionContext> {
    private static final SdkV2DataSource INSTANCE = new SdkV2DataSource();

    public static SdkV2DataSource getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String getOperationName(SdkRequest sdkRequest, ExecutionContext context) {
        return (String)context.executionAttributes().getAttribute(AwsSignerExecutionAttribute.OPERATION_NAME);
    }

    @Override
    @Nullable
    public String getRegion(SdkRequest sdkRequest, ExecutionContext context) {
        Region region = (Region)context.executionAttributes().getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION);
        if (region != null) {
            return region.id();
        }
        return null;
    }

    @Override
    @Nullable
    public String getFieldValue(String fieldName, SdkRequest sdkRequest) {
        String value = sdkRequest.getValueForField(fieldName, String.class).orElse(null);
        if ("QueueName".equals(fieldName) && value == null) {
            value = this.getQueueNameFromQueueUrl(this.getFieldValue("QueueUrl", sdkRequest));
        }
        return value;
    }
}

