/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2.helper;

import co.elastic.apm.agent.awssdk.common.AbstractSQSInstrumentationHelper;
import co.elastic.apm.agent.awssdk.v2.helper.SdkV2DataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SQSHelper
extends AbstractSQSInstrumentationHelper<SdkRequest, ExecutionContext, Message>
implements TextHeaderSetter<Map<String, MessageAttributeValue>> {
    private static final SQSHelper INSTANCE = new SQSHelper(GlobalTracer.requireTracerImpl());

    public static SQSHelper getInstance() {
        return INSTANCE;
    }

    public SQSHelper(ElasticApmTracer tracer) {
        super(tracer, SdkV2DataSource.getInstance());
    }

    private SdkRequest propagateContext(Span span, SdkRequest sdkRequest) {
        if (sdkRequest instanceof SendMessageRequest) {
            SendMessageRequest sendMessageRequest = (SendMessageRequest)sdkRequest;
            HashMap attributesMap = new HashMap(sendMessageRequest.messageAttributes());
            span.propagateTraceContext(attributesMap, this);
            return (SdkRequest)sendMessageRequest.toBuilder().messageAttributes(attributesMap).build();
        }
        if (sdkRequest instanceof SendMessageBatchRequest) {
            SendMessageBatchRequest sendMessageBatchRequest = (SendMessageBatchRequest)sdkRequest;
            SendMessageBatchRequestEntry[] newEntries = new SendMessageBatchRequestEntry[sendMessageBatchRequest.entries().size()];
            int idx = 0;
            for (SendMessageBatchRequestEntry entry : sendMessageBatchRequest.entries()) {
                HashMap attributesMap = new HashMap(entry.messageAttributes());
                span.propagateTraceContext(attributesMap, this);
                newEntries[idx] = (SendMessageBatchRequestEntry)entry.toBuilder().messageAttributes(attributesMap).build();
                ++idx;
            }
            sendMessageBatchRequest.toBuilder().entries(newEntries).build();
        }
        return sdkRequest;
    }

    @Override
    protected String getMessageBody(Message sqsMessage) {
        return sqsMessage.body();
    }

    @Override
    protected long getMessageAge(Message message) {
        String value = (String)message.attributesAsStrings().get("SentTimestamp");
        if (value != null) {
            try {
                long sentTimestampMs = Long.parseLong(value);
                return System.currentTimeMillis() - sentTimestampMs;
            }
            catch (Throwable t) {
                return Long.MIN_VALUE;
            }
        }
        return Long.MIN_VALUE;
    }

    @Override
    protected Collection<String> getMessageAttributeKeys(Message sqsMessage) {
        return sqsMessage.messageAttributes().keySet();
    }

    @Override
    @Nullable
    protected String getMessageAttribute(Message sqsMessage, String key) {
        MessageAttributeValue value;
        if (sqsMessage.hasMessageAttributes() && sqsMessage.messageAttributes().containsKey(key) && (value = (MessageAttributeValue)sqsMessage.messageAttributes().get(key)).dataType().equals("String")) {
            return value.stringValue();
        }
        return null;
    }

    public void modifyRequestObject(@Nullable Span span, ClientExecutionParams clientExecutionParams, ExecutionContext executionContext) {
        ReceiveMessageRequest receiveMessageRequest;
        SdkRequest sdkRequest = clientExecutionParams.getInput();
        SdkRequest newRequestObj = null;
        if (span != null && clientExecutionParams.getOperationName().startsWith("SendMessage")) {
            newRequestObj = SQSHelper.getInstance().propagateContext(span, clientExecutionParams.getInput());
        } else if (!(!(sdkRequest instanceof ReceiveMessageRequest) || (receiveMessageRequest = (ReceiveMessageRequest)sdkRequest).messageAttributeNames().contains("All") || receiveMessageRequest.messageAttributeNames().contains("traceparent") && receiveMessageRequest.messageAttributeNames().contains("tracestate"))) {
            List<String> attributeNames;
            ArrayList<String> newMessageAttributeNames = new ArrayList<String>(receiveMessageRequest.messageAttributeNames().size() + 2);
            newMessageAttributeNames.addAll(receiveMessageRequest.messageAttributeNames());
            newMessageAttributeNames.add("traceparent");
            newMessageAttributeNames.add("tracestate");
            if (receiveMessageRequest.attributeNamesAsStrings().isEmpty()) {
                attributeNames = Collections.singletonList("SentTimestamp");
            } else {
                attributeNames = new ArrayList<String>(receiveMessageRequest.attributeNamesAsStrings().size() + 1);
                attributeNames.add("SentTimestamp");
            }
            newRequestObj = (SdkRequest)receiveMessageRequest.toBuilder().messageAttributeNames(newMessageAttributeNames).attributeNamesWithStrings(attributeNames).build();
        }
        if (newRequestObj != null) {
            clientExecutionParams.withInput(newRequestObj);
            executionContext.interceptorContext(executionContext.interceptorContext().toBuilder().request(newRequestObj).build());
        }
    }

    @Override
    public void setHeader(String headerName, String headerValue, Map<String, MessageAttributeValue> map) {
        map.put(headerName, (MessageAttributeValue)MessageAttributeValue.builder().dataType("String").stringValue(headerValue).build());
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Message message) {
        MessageAttributeValue value = (MessageAttributeValue)message.messageAttributes().get(headerName);
        if (value != null && value.dataType().equals("String")) {
            return value.stringValue();
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, Message message, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        for (MessageAttributeValue value : message.messageAttributes().values()) {
            if (value == null || !value.dataType().equals("String")) continue;
            consumer.accept(value.stringValue(), state);
        }
    }

    public void handleReceivedMessages(Span span, @Nullable SdkRequest sdkRequest, @Nullable SdkResponse sdkResponse) {
        if (sdkResponse instanceof ReceiveMessageResponse && sdkRequest instanceof ReceiveMessageRequest) {
            SQSHelper.getInstance().handleReceivedMessages(span, ((ReceiveMessageRequest)sdkRequest).queueUrl(), ((ReceiveMessageResponse)sdkResponse).messages());
        }
    }
}

