/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.awssdk.v2.helper.SQSHelper;
import co.elastic.apm.agent.awssdk.v2.helper.sqs.wrapper.MessageListWrapper;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.awssdk.http.SdkHttpResponse;

public class ResponseHandlerWrapper<T>
implements TransformingAsyncResponseHandler<Response<T>> {
    private final TransformingAsyncResponseHandler<Response<T>> delegate;
    @Nullable
    private final Span span;
    private final SdkRequest sdkRequest;
    private final String awsService;

    public ResponseHandlerWrapper(String awsService, TransformingAsyncResponseHandler<Response<T>> delegate, SdkRequest request, @Nullable Span span) {
        this.awsService = awsService;
        this.delegate = delegate;
        this.span = span;
        this.sdkRequest = request;
    }

    public CompletableFuture<Response<T>> prepare() {
        CompletableFuture delegateFuture = this.delegate.prepare();
        delegateFuture.whenComplete((r, t) -> {
            Object response = r.response();
            if (this.span != null) {
                if (t != null) {
                    this.span.captureException((Throwable)t);
                    this.span.withOutcome(Outcome.FAILURE);
                } else if (r.exception() != null) {
                    this.span.captureException((Throwable)r.exception());
                    this.span.withOutcome(Outcome.FAILURE);
                } else {
                    this.span.withOutcome(Outcome.SUCCESS);
                }
                if ("Sqs".equalsIgnoreCase(this.awsService) && response instanceof SdkResponse) {
                    SQSHelper.getInstance().handleReceivedMessages(this.span, this.sdkRequest, (SdkResponse)response);
                }
                this.span.end();
            }
            if ("Sqs".equalsIgnoreCase(this.awsService) && response instanceof SdkResponse) {
                MessageListWrapper.registerWrapperListForResponse(this.sdkRequest, (SdkResponse)response, SQSHelper.getInstance().getTracer());
            }
        });
        return delegateFuture;
    }

    public void onHeaders(SdkHttpResponse sdkHttpResponse) {
        this.delegate.onHeaders(sdkHttpResponse);
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        this.delegate.onStream(publisher);
    }

    public void onError(Throwable throwable) {
        if (this.span != null && !this.span.isFinished()) {
            this.span.captureException(throwable);
            this.span.withOutcome(Outcome.FAILURE);
        }
        this.delegate.onError(throwable);
    }
}

