/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.awssdk.v2.helper.sqs.wrapper.MessageListWrapper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.sdk.state.CallDepth;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

public class GetMessagesInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("messages").and(ElementMatchers.returns(ElementMatchers.named("java.util.List"))).and(ElementMatchers.takesNoArguments());
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        private static final CallDepth callDepth = CallDepth.get(AdviceClass.class);

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        @Advice.AssignReturned.ToReturned
        public static List<Message> onExit(@Advice.This ReceiveMessageResponse response, @Advice.Return List<Message> messagesList) {
            List<Message> wrappedList;
            List<Message> returnedList = messagesList;
            if (!callDepth.isNestedCallAndIncrement() && !messagesList.isEmpty() && (wrappedList = MessageListWrapper.getMessagesList(response)) != null) {
                returnedList = wrappedList;
            }
            callDepth.decrement();
            return returnedList;
        }
    }
}

