/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.awssdk.v2.helper.DynamoDbHelper;
import co.elastic.apm.agent.awssdk.v2.helper.S3Helper;
import co.elastic.apm.agent.awssdk.v2.helper.SQSHelper;
import co.elastic.apm.agent.awssdk.v2.helper.sqs.wrapper.MessageListWrapper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.ExecutionContext;

public class BaseSyncClientHandlerInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("software.amazon.awssdk.core.internal.handler.BaseSyncClientHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("doExecute").and(ElementMatchers.takesArgument(0, ElementMatchers.named("software.amazon.awssdk.core.client.handler.ClientExecutionParams"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("software.amazon.awssdk.core.http.ExecutionContext")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object enterDoExecute(@Advice.Argument(value=0) ClientExecutionParams clientExecutionParams, @Advice.Argument(value=1) ExecutionContext executionContext, @Advice.FieldValue(value="clientConfiguration") SdkClientConfiguration clientConfiguration) {
            String awsService = (String)executionContext.executionAttributes().getAttribute(AwsSignerExecutionAttribute.SERVICE_NAME);
            SdkRequest sdkRequest = clientExecutionParams.getInput();
            URI uri = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
            Span span = null;
            if ("S3".equalsIgnoreCase(awsService)) {
                span = S3Helper.getInstance().startSpan(sdkRequest, uri, executionContext);
            } else if ("DynamoDb".equalsIgnoreCase(awsService)) {
                span = DynamoDbHelper.getInstance().startSpan(sdkRequest, uri, executionContext);
            } else if ("Sqs".equalsIgnoreCase(awsService)) {
                span = SQSHelper.getInstance().startSpan(sdkRequest, uri, executionContext);
                SQSHelper.getInstance().modifyRequestObject(span, clientExecutionParams, executionContext);
            }
            if (span != null) {
                span.activate();
            }
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void exitDoExecute(@Advice.Argument(value=0) ClientExecutionParams clientExecutionParams, @Advice.Argument(value=1) ExecutionContext executionContext, @Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown, @Nullable @Advice.Return Object sdkResponse) {
            String awsService = (String)executionContext.executionAttributes().getAttribute(AwsSignerExecutionAttribute.SERVICE_NAME);
            SdkRequest sdkRequest = clientExecutionParams.getInput();
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                span.deactivate();
                if (thrown != null) {
                    span.captureException(thrown);
                    span.withOutcome(Outcome.FAILURE);
                } else {
                    span.withOutcome(Outcome.SUCCESS);
                }
                if ("Sqs".equalsIgnoreCase(awsService) && sdkResponse instanceof SdkResponse) {
                    SQSHelper.getInstance().handleReceivedMessages(span, sdkRequest, (SdkResponse)sdkResponse);
                }
                span.end();
            }
            if ("Sqs".equalsIgnoreCase(awsService) && sdkResponse instanceof SdkResponse) {
                MessageListWrapper.registerWrapperListForResponse(sdkRequest, (SdkResponse)sdkResponse, SQSHelper.getInstance().getTracer());
            }
        }
    }
}

