/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.awssdk.v2.ResponseHandlerWrapper;
import co.elastic.apm.agent.awssdk.v2.helper.DynamoDbHelper;
import co.elastic.apm.agent.awssdk.v2.helper.S3Helper;
import co.elastic.apm.agent.awssdk.v2.helper.SQSHelper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;

public class BaseAsyncClientHandlerInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("software.amazon.awssdk.core.internal.handler.BaseAsyncClientHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("doExecute").and(ElementMatchers.takesArgument(0, ElementMatchers.named("software.amazon.awssdk.core.client.handler.ClientExecutionParams"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("software.amazon.awssdk.core.http.ExecutionContext")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=2)})
        public static TransformingAsyncResponseHandler<?> enterDoExecute(@Advice.Argument(value=0) ClientExecutionParams clientExecutionParams, @Advice.Argument(value=1) ExecutionContext executionContext, @Advice.Argument(value=2) TransformingAsyncResponseHandler<?> responseHandler, @Advice.FieldValue(value="clientConfiguration") SdkClientConfiguration clientConfiguration) {
            String awsService = (String)executionContext.executionAttributes().getAttribute(AwsSignerExecutionAttribute.SERVICE_NAME);
            SdkRequest sdkRequest = clientExecutionParams.getInput();
            URI uri = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
            Span span = null;
            if ("S3".equalsIgnoreCase(awsService)) {
                span = S3Helper.getInstance().startSpan(sdkRequest, uri, executionContext);
            } else if ("DynamoDb".equalsIgnoreCase(awsService)) {
                span = DynamoDbHelper.getInstance().startSpan(sdkRequest, uri, executionContext);
            } else if ("Sqs".equalsIgnoreCase(awsService)) {
                span = SQSHelper.getInstance().startSpan(sdkRequest, uri, executionContext);
                SQSHelper.getInstance().modifyRequestObject(span, clientExecutionParams, executionContext);
            }
            if (span != null) {
                span.withSync(false);
            }
            return new ResponseHandlerWrapper(awsService, responseHandler, sdkRequest, span);
        }
    }
}

