/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1.helper.sqs.wrapper;

import co.elastic.apm.agent.awssdk.v1.helper.sqs.wrapper.MessageListWrapper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.Collection;
import java.util.List;

public class ReceiveMessageResultWrapper
extends ReceiveMessageResult {
    private final ReceiveMessageResult delegate;
    private final ElasticApmTracer tracer;
    private final String queueName;
    private final MessageListWrapper listWrapper;

    public ReceiveMessageResultWrapper(ReceiveMessageResult delegate, ElasticApmTracer tracer, String queueName) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.queueName = queueName;
        this.listWrapper = new MessageListWrapper(delegate.getMessages(), tracer, queueName);
    }

    public List<Message> getMessages() {
        this.listWrapper.updateDelegate(this.delegate.getMessages());
        return this.listWrapper;
    }

    public void setMessages(Collection<Message> messages) {
        this.delegate.setMessages(messages);
    }

    public ReceiveMessageResult withMessages(Message ... messages) {
        this.delegate.withMessages(messages);
        return this;
    }

    public ReceiveMessageResult withMessages(Collection<Message> messages) {
        this.delegate.withMessages(messages);
        return this;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ReceiveMessageResult clone() {
        return new ReceiveMessageResultWrapper(this.delegate.clone(), this.tracer, this.queueName);
    }
}

