/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1.helper;

import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import javax.annotation.Nullable;

public class SdkV1DataSource
extends IAwsSdkDataSource<Request<?>, ExecutionContext> {
    private static final SdkV1DataSource INSTANCE = new SdkV1DataSource();
    private final WeakMap<Object, String> requestLookupMap = WeakConcurrent.buildMap();

    public static SdkV1DataSource getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public String getOperationName(Request<?> request, ExecutionContext context) {
        return (String)request.getHandlerContext(HandlerContextKey.OPERATION_NAME);
    }

    @Override
    @Nullable
    public String getRegion(Request<?> request, ExecutionContext context) {
        return (String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
    }

    @Override
    @Nullable
    public String getFieldValue(String fieldName, Request<?> request) {
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        if ("Bucket".equals(fieldName) || "TableName".equals(fieldName) || "QueueName".equals(fieldName)) {
            return this.requestLookupMap.get(amazonWebServiceRequest);
        }
        if ("KeyConditionExpression".equals(fieldName) && amazonWebServiceRequest instanceof QueryRequest) {
            return ((QueryRequest)amazonWebServiceRequest).getKeyConditionExpression();
        }
        return null;
    }

    public void putLookupValue(Object key, @Nullable String stringValue) {
        if (stringValue != null && !this.requestLookupMap.containsKey(key)) {
            this.requestLookupMap.put(key, stringValue);
        }
    }

    public void removeLookupValue(Object key) {
        this.requestLookupMap.remove(key);
    }
}

