/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1.helper;

import co.elastic.apm.agent.awssdk.common.AbstractSQSInstrumentationHelper;
import co.elastic.apm.agent.awssdk.v1.helper.Constants;
import co.elastic.apm.agent.awssdk.v1.helper.SdkV1DataSource;
import co.elastic.apm.agent.awssdk.v1.helper.sqs.wrapper.ReceiveMessageResultWrapper;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SQSHelper
extends AbstractSQSInstrumentationHelper<Request<?>, ExecutionContext, Message>
implements TextHeaderSetter<Map<String, MessageAttributeValue>> {
    private static final SQSHelper INSTANCE = new SQSHelper(GlobalTracer.requireTracerImpl());

    public static SQSHelper getInstance() {
        return INSTANCE;
    }

    protected SQSHelper(ElasticApmTracer tracer) {
        super(tracer, SdkV1DataSource.getInstance());
    }

    public void propagateContext(Span span, AmazonWebServiceRequest request) {
        if (request instanceof SendMessageRequest) {
            SendMessageRequest sendMessageRequest = (SendMessageRequest)request;
            span.propagateTraceContext(sendMessageRequest.getMessageAttributes(), this);
        } else if (request instanceof SendMessageBatchRequest) {
            SendMessageBatchRequest sendMessageBatchRequest = (SendMessageBatchRequest)request;
            for (SendMessageBatchRequestEntry entry : sendMessageBatchRequest.getEntries()) {
                span.propagateTraceContext(entry.getMessageAttributes(), this);
            }
        }
    }

    public void setMessageAttributeNames(ReceiveMessageRequest receiveMessageRequest) {
        List attributeNames;
        List messageAttributeNames = receiveMessageRequest.getMessageAttributeNames();
        if (!messageAttributeNames.contains("All") && !messageAttributeNames.contains("traceparent")) {
            messageAttributeNames.add("traceparent");
        }
        if (!messageAttributeNames.contains("All") && !messageAttributeNames.contains("tracestate")) {
            messageAttributeNames.add("tracestate");
        }
        if (!(attributeNames = receiveMessageRequest.getAttributeNames()).contains("SentTimestamp")) {
            attributeNames.add("SentTimestamp");
        }
    }

    @Override
    protected String getMessageBody(Message sqsMessage) {
        return sqsMessage.getBody();
    }

    @Override
    protected long getMessageAge(Message message) {
        String value = (String)message.getAttributes().get("SentTimestamp");
        if (value != null) {
            try {
                long sentTimestampMs = Long.parseLong(value);
                return System.currentTimeMillis() - sentTimestampMs;
            }
            catch (Throwable t) {
                return Long.MIN_VALUE;
            }
        }
        return Long.MIN_VALUE;
    }

    @Override
    protected Collection<String> getMessageAttributeKeys(Message sqsMessage) {
        return sqsMessage.getMessageAttributes().keySet();
    }

    @Override
    @Nullable
    protected String getMessageAttribute(Message sqsMessage, String key) {
        MessageAttributeValue value;
        if (sqsMessage.getMessageAttributes() != null && sqsMessage.getMessageAttributes().containsKey(key) && (value = (MessageAttributeValue)sqsMessage.getMessageAttributes().get(key)).getDataType().equals("String")) {
            return value.getStringValue();
        }
        return null;
    }

    @Override
    protected void setMessageContext(@Nullable Message sqsMessage, @Nullable String queueName, co.elastic.apm.agent.impl.context.Message message) {
        if (queueName != null) {
            message.withQueue(queueName);
        }
        if (sqsMessage != null) {
            long messageAge = this.getMessageAge(sqsMessage);
            if (messageAge >= 0L) {
                message.withAge(messageAge);
            }
            if (this.coreConfiguration.isCaptureHeaders()) {
                for (Map.Entry entry : sqsMessage.getMessageAttributes().entrySet()) {
                    String key = (String)entry.getKey();
                    if ("traceparent".equals(key) || "tracestate".equals(key) || !((MessageAttributeValue)entry.getValue()).getDataType().equals("String") || WildcardMatcher.anyMatch(this.coreConfiguration.getSanitizeFieldNames(), key) != null) continue;
                    message.addHeader(key, ((MessageAttributeValue)entry.getValue()).getStringValue());
                }
            }
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF) {
                message.appendToBody(sqsMessage.getBody());
            }
        }
    }

    @Override
    @Nullable
    public Span startSpan(Request<?> request, URI httpURI, ExecutionContext context) {
        if (SQSHelper.isAlreadyActive(request)) {
            Span activeSpan = this.tracer.getActiveExitSpan();
            if (activeSpan != null && "sqs".equals(activeSpan.getSubtype())) {
                this.enrichSpan(activeSpan, request, request.getEndpoint(), context);
                activeSpan.withSync(this.isRequestSync(request.getOriginalRequest()));
            }
        } else {
            Span span = super.startSpan(request, request.getEndpoint(), context);
            if (span != null) {
                span.withSync(this.isRequestSync(request.getOriginalRequest()));
                return span;
            }
        }
        return null;
    }

    private static boolean isAlreadyActive(Request<?> request) {
        AmazonWebServiceRequest amazonRequest = request.getOriginalRequest();
        return amazonRequest instanceof SendMessageRequest || amazonRequest instanceof SendMessageBatchRequest || amazonRequest instanceof ReceiveMessageRequest;
    }

    private boolean isRequestSync(AmazonWebServiceRequest amazonRequest) {
        Boolean isAsync = (Boolean)amazonRequest.getHandlerContext(Constants.ASYNC_HANDLER_CONTEXT);
        return isAsync == null || isAsync == false;
    }

    public ReceiveMessageResult wrapResult(ReceiveMessageRequest receiveMessageRequest, ReceiveMessageResult result) {
        String queueName;
        ReceiveMessageResult returnedResult = result;
        List messages = result.getMessages();
        if (messages.size() > 0 && (queueName = SdkV1DataSource.getInstance().getQueueNameFromQueueUrl(receiveMessageRequest.getQueueUrl())) != null) {
            returnedResult = new ReceiveMessageResultWrapper(result, SQSHelper.getInstance().getTracer(), queueName);
        }
        return returnedResult;
    }

    @Override
    public void setHeader(String headerName, String headerValue, Map<String, MessageAttributeValue> map) {
        map.put(headerName, new MessageAttributeValue().withDataType("String").withStringValue(headerValue));
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, Message message) {
        MessageAttributeValue value = (MessageAttributeValue)message.getMessageAttributes().get(headerName);
        if (value != null && value.getDataType().equals("String")) {
            return value.getStringValue();
        }
        return null;
    }

    @Override
    public <S> void forEach(String headerName, Message message, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        for (MessageAttributeValue value : message.getMessageAttributes().values()) {
            if (value == null || !value.getDataType().equals("String")) continue;
            consumer.accept(value.getStringValue(), state);
        }
    }
}

