/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1.helper;

import co.elastic.apm.agent.awssdk.common.AbstractDynamoDBInstrumentationHelper;
import co.elastic.apm.agent.awssdk.v1.helper.Constants;
import co.elastic.apm.agent.awssdk.v1.helper.SdkV1DataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.http.ExecutionContext;
import java.net.URI;
import javax.annotation.Nullable;

public class DynamoDbHelper
extends AbstractDynamoDBInstrumentationHelper<Request<?>, ExecutionContext> {
    private static final DynamoDbHelper INSTANCE = new DynamoDbHelper(GlobalTracer.requireTracerImpl());

    public static DynamoDbHelper getInstance() {
        return INSTANCE;
    }

    public DynamoDbHelper(ElasticApmTracer tracer) {
        super(tracer, SdkV1DataSource.getInstance());
    }

    @Override
    @Nullable
    public Span startSpan(Request<?> request, URI httpURI, ExecutionContext context) {
        AmazonWebServiceRequest amazonRequest = request.getOriginalRequest();
        Span span = super.startSpan(request, httpURI, context);
        if (span != null) {
            span.withSync(!this.isRequestAsync(amazonRequest));
        }
        return span;
    }

    private boolean isRequestAsync(AmazonWebServiceRequest amazonRequest) {
        Boolean isAsync = (Boolean)amazonRequest.getHandlerContext(Constants.ASYNC_HANDLER_CONTEXT);
        return isAsync != null && isAsync != false;
    }
}

