/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1;

import co.elastic.apm.agent.awssdk.common.AbstractAwsSdkInstrumentation;
import co.elastic.apm.agent.awssdk.v1.helper.SQSHelper;
import co.elastic.apm.agent.awssdk.v1.helper.SdkV1DataSource;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.state.CallDepth;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class SQSMessageDispatchingInstrumentation
extends AbstractAwsSdkInstrumentation {
    protected static final CallDepth jmsReceiveMessageCallDepth = CallDepth.get(AmazonSQSMessagingClientWrapperInstrumentation.class);

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.amazonaws.services.sqs.AmazonSQSClient");
    }

    protected static void endSpan(@Nullable Object spanObj, @Nullable Throwable thrown) {
        if (spanObj instanceof Span) {
            Span span = (Span)spanObj;
            span.deactivate();
            if (thrown != null) {
                span.captureException(thrown);
                span.withOutcome(Outcome.FAILURE);
            } else {
                span.withOutcome(Outcome.SUCCESS);
            }
            span.end();
        }
    }

    public static class AmazonSQSMessagingClientWrapperInstrumentation
    extends SQSMessageDispatchingInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("receiveMessage").and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.amazonaws.services.sqs.model.ReceiveMessageRequest")));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void enterReceiveMessage() {
                jmsReceiveMessageCallDepth.increment();
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitReceiveMessage() {
                jmsReceiveMessageCallDepth.decrement();
            }
        }
    }

    public static class SQSReceiveMessageInstrumentation
    extends SQSMessageDispatchingInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("executeReceiveMessage").and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.amazonaws.services.sqs.model.ReceiveMessageRequest")));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object enterReceiveMessage(@Advice.Argument(value=0) ReceiveMessageRequest receiveMessageRequest) {
                String queueName = SdkV1DataSource.getInstance().getQueueNameFromQueueUrl(receiveMessageRequest.getQueueUrl());
                Span span = SQSHelper.getInstance().createSpan(queueName);
                if (span != null) {
                    span.activate();
                    SdkV1DataSource.getInstance().putLookupValue(receiveMessageRequest, queueName);
                }
                SQSHelper.getInstance().setMessageAttributeNames(receiveMessageRequest);
                return span;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            @Advice.AssignReturned.ToReturned
            public static ReceiveMessageResult exitReceiveMessage(@Nullable @Advice.Enter Object spanObj, @Advice.Argument(value=0) ReceiveMessageRequest receiveMessageRequest, @Advice.Return ReceiveMessageResult result, @Nullable @Advice.Thrown Throwable thrown) {
                if (spanObj instanceof Span) {
                    SQSHelper.getInstance().handleReceivedMessages((Span)spanObj, receiveMessageRequest.getQueueUrl(), result.getMessages());
                }
                SQSMessageDispatchingInstrumentation.endSpan(spanObj, thrown);
                ReceiveMessageResult returnedResult = result;
                if (!jmsReceiveMessageCallDepth.isNestedCallAndIncrement()) {
                    returnedResult = SQSHelper.getInstance().wrapResult(receiveMessageRequest, result);
                }
                jmsReceiveMessageCallDepth.decrement();
                return returnedResult;
            }
        }
    }

    public static class SendMessageInstrumentation
    extends SQSMessageDispatchingInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("executeSendMessage").and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.amazonaws.services.sqs.model.SendMessageRequest"))).or(ElementMatchers.named("executeSendMessageBatch").and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.amazonaws.services.sqs.model.SendMessageBatchRequest"))));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object enterSendMessage(@Advice.Argument(value=0) AmazonWebServiceRequest request) {
                String queueUrl = null;
                if (request instanceof SendMessageRequest) {
                    queueUrl = ((SendMessageRequest)request).getQueueUrl();
                } else if (request instanceof SendMessageBatchRequest) {
                    queueUrl = ((SendMessageBatchRequest)request).getQueueUrl();
                }
                String queueName = SdkV1DataSource.getInstance().getQueueNameFromQueueUrl(queueUrl);
                if (queueName == null) {
                    return null;
                }
                Span span = SQSHelper.getInstance().createSpan(queueName);
                if (span != null) {
                    SQSHelper.getInstance().propagateContext(span, request);
                    span.activate();
                    SdkV1DataSource.getInstance().putLookupValue(request, queueName);
                }
                return span;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitSendMessage(@Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
                SQSMessageDispatchingInstrumentation.endSpan(spanObj, thrown);
            }
        }
    }
}

