/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1;

import co.elastic.apm.agent.awssdk.common.AbstractAwsSdkInstrumentation;
import co.elastic.apm.agent.awssdk.v1.helper.SdkV1DataSource;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class EntityLookupInstrumentation
extends AbstractAwsSdkInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("com.amazonaws.services.").and(ElementMatchers.nameEndsWith("Request")).and(super.getTypeMatcherPreFilter());
    }

    public static class S3GetDestinationBucketNameInstrumentation
    extends EntityLookupInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.nameContains("s3.model").and(ElementMatchers.declaresMethod(ElementMatchers.named("getDestinationBucketName")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("getDestinationBucketName");
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitGetQueueUrl(@Advice.This Object requestObject, @Nullable @Advice.Return String bucketName) {
                SdkV1DataSource.getInstance().putLookupValue(requestObject, bucketName);
            }
        }
    }

    public static class S3GetBucketNameInstrumentation
    extends EntityLookupInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.nameContains("s3.model").and(ElementMatchers.declaresMethod(ElementMatchers.named("getBucketName")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("getBucketName");
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitGetQueueUrl(@Advice.This Object requestObject, @Nullable @Advice.Return String bucketName) {
                SdkV1DataSource.getInstance().putLookupValue(requestObject, bucketName);
            }
        }
    }

    public static class SQSGetQueueUrlInstrumentation
    extends EntityLookupInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.nameContains("sqs.model").and(ElementMatchers.not(ElementMatchers.nameStartsWith("com.amazonaws.services.sqs.model.SendMessage"))).and(ElementMatchers.not(ElementMatchers.named("com.amazonaws.services.sqs.model.ReceiveMessageRequest"))).and(ElementMatchers.declaresMethod(ElementMatchers.named("getQueueUrl")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("getQueueUrl");
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitGetQueueUrl(@Advice.This Object requestObject, @Nullable @Advice.Return String queueUrl) {
                String queueName = SdkV1DataSource.getInstance().getQueueNameFromQueueUrl(queueUrl);
                SdkV1DataSource.getInstance().putLookupValue(requestObject, queueName);
            }
        }
    }

    public static class SQSGetQueueNameInstrumentation
    extends EntityLookupInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.nameContains("sqs.model").and(ElementMatchers.not(ElementMatchers.nameStartsWith("com.amazonaws.services.sqs.model.SendMessage"))).and(ElementMatchers.not(ElementMatchers.named("com.amazonaws.services.sqs.model.ReceiveMessageRequest"))).and(ElementMatchers.declaresMethod(ElementMatchers.named("getQueueName")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("getQueueName");
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitGetQueueName(@Advice.This Object requestObject, @Nullable @Advice.Return String queueName) {
                SdkV1DataSource.getInstance().putLookupValue(requestObject, queueName);
            }
        }
    }

    public static class DynamoDBGetTableNameInstrumentation
    extends EntityLookupInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.nameContains("dynamodbv2.model").and(ElementMatchers.declaresMethod(ElementMatchers.named("getTableName")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("getTableName");
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
            public static void exitGetTableName(@Advice.This Object requestObject, @Nullable @Advice.Return String tableName) {
                SdkV1DataSource.getInstance().putLookupValue(requestObject, tableName);
            }
        }
    }
}

