/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1;

import co.elastic.apm.agent.awssdk.common.AbstractAwsSdkInstrumentation;
import co.elastic.apm.agent.awssdk.v1.helper.Constants;
import com.amazonaws.AmazonWebServiceRequest;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AsyncClientInstrumentation
extends AbstractAwsSdkInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.amazonaws.services.sqs.AmazonSQSAsyncClient").or(ElementMatchers.named("com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClient"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameEndsWith("Async").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("Request")));
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void enterMethodEnter(@Advice.Argument(value=0) AmazonWebServiceRequest request) {
            request.addHandlerContext(Constants.ASYNC_HANDLER_CONTEXT, (Object)true);
        }
    }
}

