/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.AbstractAwsSdkInstrumentationHelper;
import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractSQSInstrumentationHelper<R, C, MessageT>
extends AbstractAwsSdkInstrumentationHelper<R, C>
implements TextHeaderGetter<MessageT> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQSInstrumentationHelper.class);
    protected static final String SQS_TYPE = "sqs";
    protected static final String MESSAGE_PROCESSING_ACTION = "processing";
    protected static final String MESSAGING_TYPE = "messaging";
    protected static final String ATTRIBUTE_NAME_SENT_TIMESTAMP = "SentTimestamp";
    protected static final String ATTRIBUTE_DATA_TYPE_STRING = "String";
    protected static final String ATTRIBUTE_NAME_ALL = "All";
    protected static final String FRAMEWORK_NAME = "AWS SQS";
    public static final Map<String, SpanNameAction> SPAN_NAME_LOOKUP = new HashMap<String, SpanNameAction>();
    protected final MessagingConfiguration messagingConfiguration;
    protected final CoreConfiguration coreConfiguration;

    protected abstract String getMessageBody(MessageT var1);

    protected abstract long getMessageAge(MessageT var1);

    protected abstract Collection<String> getMessageAttributeKeys(MessageT var1);

    @Nullable
    protected abstract String getMessageAttribute(MessageT var1, String var2);

    protected AbstractSQSInstrumentationHelper(ElasticApmTracer tracer, IAwsSdkDataSource<R, C> awsSdkDataSource) {
        super(tracer, awsSdkDataSource);
        this.messagingConfiguration = tracer.getConfig(MessagingConfiguration.class);
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
    }

    @Nullable
    public Span createSpan(@Nullable String queueName) {
        if (WildcardMatcher.isAnyMatch(this.messagingConfiguration.getIgnoreMessageQueues(), queueName)) {
            return null;
        }
        Span span = this.tracer.createExitChildSpan();
        if (span != null) {
            ((Span)span.withType(MESSAGING_TYPE)).withSubtype(SQS_TYPE);
        }
        return span;
    }

    public void enrichSpan(Span span, R request, URI httpURI, C context) {
        String operationName = this.awsSdkDataSource.getOperationName(request, context);
        String queueName = this.awsSdkDataSource.getFieldValue("QueueName", request);
        String action = operationName;
        String spanNameOperation = operationName;
        SpanNameAction nameAndAction = SPAN_NAME_LOOKUP.get(operationName);
        if (nameAndAction != null) {
            action = nameAndAction.getAction();
            spanNameOperation = nameAndAction.getSpanNameOperation();
        }
        ((Span)span.withType(MESSAGING_TYPE)).withSubtype(SQS_TYPE).withAction(action);
        if (span.isSampled()) {
            StringBuilder name = span.getAndOverrideName(0);
            if (name != null) {
                name.append("SQS ").append(spanNameOperation);
                if (queueName != null && !queueName.isEmpty()) {
                    name.append(" ").append(queueName);
                }
            }
            span.withName("SQS", -1);
            if (queueName != null) {
                span.getContext().getMessage().withQueue(queueName);
            }
            this.setDestinationContext(span, httpURI, request, context, SQS_TYPE, queueName);
        }
    }

    @Override
    @Nullable
    public Span startSpan(R request, URI httpURI, C context) {
        Transaction transaction;
        AbstractSpan<?> activeSpan = this.tracer.getActive();
        if (this.messagingConfiguration.shouldEndMessagingTransactionOnPoll() && activeSpan instanceof Transaction && MESSAGING_TYPE.equals((transaction = (Transaction)activeSpan).getType())) {
            ((Transaction)transaction.deactivate()).end();
            return null;
        }
        String queueName = this.awsSdkDataSource.getFieldValue("QueueName", request);
        Span span = this.createSpan(queueName);
        if (span != null) {
            this.enrichSpan(span, request, httpURI, context);
        }
        return span;
    }

    public void startTransactionOnMessage(MessageT sqsMessage, String queueName, TextHeaderGetter<MessageT> headerGetter) {
        try {
            Transaction transaction;
            if (!WildcardMatcher.isAnyMatch(this.messagingConfiguration.getIgnoreMessageQueues(), queueName) && (transaction = this.tracer.startChildTransaction(sqsMessage, headerGetter, PrivilegedActionUtils.getClassLoader(AbstractSQSInstrumentationHelper.class))) != null) {
                ((Transaction)((Transaction)transaction.withType(MESSAGING_TYPE)).withName("SQS RECEIVE from " + queueName)).activate();
                transaction.setFrameworkName(FRAMEWORK_NAME);
                if (transaction.isSampled()) {
                    this.setMessageContext(sqsMessage, queueName, transaction.getContext().getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in transaction creation based on SQS message", e);
        }
    }

    private void addSpanLink(Span span, MessageT sqsMessage, TextHeaderGetter<MessageT> headerGetter) {
        span.addSpanLink(TraceContext.getFromTraceContextTextHeaders(), headerGetter, sqsMessage);
    }

    protected void setMessageContext(@Nullable MessageT sqsMessage, @Nullable String queueName, Message message) {
        if (queueName != null) {
            message.withQueue(queueName);
        }
        if (sqsMessage != null) {
            long messageAge = this.getMessageAge(sqsMessage);
            if (messageAge >= 0L) {
                message.withAge(messageAge);
            }
            if (this.coreConfiguration.isCaptureHeaders()) {
                for (String key : this.getMessageAttributeKeys(sqsMessage)) {
                    String value = this.getMessageAttribute(sqsMessage, key);
                    if ("traceparent".equals(key) || "tracestate".equals(key) || value == null || WildcardMatcher.anyMatch(this.coreConfiguration.getSanitizeFieldNames(), key) != null) continue;
                    message.addHeader(key, value);
                }
            }
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF) {
                message.appendToBody(this.getMessageBody(sqsMessage));
            }
        }
    }

    public void handleReceivedMessages(Span span, String queueUrl, @Nullable List<MessageT> messages) {
        String queueName = this.awsSdkDataSource.getQueueNameFromQueueUrl(queueUrl);
        MessageT singleMessage = null;
        if (messages != null) {
            if (messages.size() == 1) {
                singleMessage = messages.get(0);
            }
            for (MessageT msg : messages) {
                this.addSpanLink(span, msg, this);
            }
        }
        this.setMessageContext(singleMessage, queueName, span.getContext().getMessage());
    }

    static {
        SPAN_NAME_LOOKUP.put("SendMessage", new SpanNameAction("SEND to", "send"));
        SPAN_NAME_LOOKUP.put("SendMessageBatch", new SpanNameAction("SEND_BATCH to", "send_batch"));
        SPAN_NAME_LOOKUP.put("ReceiveMessage", new SpanNameAction("POLL from", "poll"));
        SPAN_NAME_LOOKUP.put("DeleteMessage", new SpanNameAction("DELETE from", "delete"));
        SPAN_NAME_LOOKUP.put("DeleteMessageBatch", new SpanNameAction("DELETE_BATCH from", "delete_batch"));
    }

    private static class SpanNameAction {
        private final String spanName;
        private final String action;

        public SpanNameAction(String spanName, String action) {
            this.spanName = spanName;
            this.action = action;
        }

        public String getSpanNameOperation() {
            return this.spanName;
        }

        public String getAction() {
            return this.action;
        }
    }
}

