/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.AbstractAwsSdkInstrumentationHelper;
import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import javax.annotation.Nullable;

public abstract class AbstractS3InstrumentationHelper<R, C>
extends AbstractAwsSdkInstrumentationHelper<R, C> {
    public static final String S3_TYPE = "s3";

    protected AbstractS3InstrumentationHelper(ElasticApmTracer tracer, IAwsSdkDataSource<R, C> awsSdkDataSource) {
        super(tracer, awsSdkDataSource);
    }

    @Override
    @Nullable
    public Span startSpan(R request, URI httpURI, C context) {
        Span span = this.tracer.createExitChildSpan();
        if (span == null) {
            return null;
        }
        String operationName = this.awsSdkDataSource.getOperationName(request, context);
        String bucketName = this.awsSdkDataSource.getFieldValue("Bucket", request);
        ((Span)span.withType("storage")).withSubtype(S3_TYPE).withAction(operationName);
        StringBuilder name = span.getAndOverrideName(0);
        if (name != null) {
            name.append("S3 ").append(operationName);
            if (bucketName != null && !bucketName.isEmpty()) {
                name.append(" ").append(bucketName);
            }
        }
        span.withName("S3", -1);
        this.setDestinationContext(span, httpURI, request, context, S3_TYPE, bucketName);
        return span;
    }
}

