/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.AbstractSQSInstrumentationHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageIteratorWrapper<Message>
implements Iterator<Message> {
    public static final Logger logger = LoggerFactory.getLogger(AbstractMessageIteratorWrapper.class);
    private final Iterator<Message> delegate;
    private final ElasticApmTracer tracer;
    private final String queueName;
    private final AbstractSQSInstrumentationHelper<?, ?, Message> sqsInstrumentationHelper;
    private final TextHeaderGetter<Message> textHeaderGetter;

    public AbstractMessageIteratorWrapper(Iterator<Message> delegate, ElasticApmTracer tracer, String queueName, AbstractSQSInstrumentationHelper<?, ?, Message> sqsInstrumentationHelper, TextHeaderGetter<Message> textHeaderGetter) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.queueName = queueName;
        this.sqsInstrumentationHelper = sqsInstrumentationHelper;
        this.textHeaderGetter = textHeaderGetter;
    }

    @Override
    public boolean hasNext() {
        this.endCurrentTransaction();
        this.endMessageProcessingSpan();
        return this.delegate.hasNext();
    }

    @Nullable
    public Transaction endCurrentTransaction() {
        Transaction transaction = null;
        try {
            transaction = this.tracer.currentTransaction();
            if (transaction != null && "messaging".equals(transaction.getType())) {
                ((Transaction)transaction.deactivate()).end();
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in AWS SQS iterator wrapper", e);
        }
        return transaction;
    }

    public void endMessageProcessingSpan() {
        Span span = this.tracer.getActiveSpan();
        if (span != null && span.getType() != null && span.getType().equals("messaging") && span.getSubtype() != null && span.getSubtype().equals("sqs") && span.getAction() != null && span.getAction().equals("processing")) {
            ((Span)span.deactivate()).end();
        }
    }

    @Override
    public Message next() {
        Transaction currentTransaction = this.endCurrentTransaction();
        Message sqsMessage = this.delegate.next();
        if (currentTransaction == null) {
            this.sqsInstrumentationHelper.startTransactionOnMessage(sqsMessage, this.queueName, this.textHeaderGetter);
        }
        return sqsMessage;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

