/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.AbstractAwsSdkInstrumentationHelper;
import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import javax.annotation.Nullable;

public abstract class AbstractDynamoDBInstrumentationHelper<R, C>
extends AbstractAwsSdkInstrumentationHelper<R, C> {
    public static final String DYNAMO_DB_TYPE = "dynamodb";

    protected AbstractDynamoDBInstrumentationHelper(ElasticApmTracer tracer, IAwsSdkDataSource<R, C> awsSdkDataSource) {
        super(tracer, awsSdkDataSource);
    }

    public void enrichSpan(Span span, R sdkRequest, URI httpURI, C context) {
        StringBuilder name;
        String operationName = this.awsSdkDataSource.getOperationName(sdkRequest, context);
        String region = this.awsSdkDataSource.getRegion(sdkRequest, context);
        String tableName = this.awsSdkDataSource.getFieldValue("TableName", sdkRequest);
        ((Span)span.withType("db")).withSubtype(DYNAMO_DB_TYPE).withAction("query");
        span.getContext().getDb().withInstance(region).withType(DYNAMO_DB_TYPE);
        if ("Query".equals(operationName)) {
            span.getContext().getDb().withStatement(this.awsSdkDataSource.getFieldValue("KeyConditionExpression", sdkRequest));
        }
        if ((name = span.getAndOverrideName(0)) != null) {
            name.append("DynamoDB ").append(operationName);
            if (tableName != null) {
                name.append(" ").append(tableName);
            }
        }
        this.setDestinationContext(span, httpURI, sdkRequest, context, DYNAMO_DB_TYPE, null);
    }

    @Override
    @Nullable
    public Span startSpan(R sdkRequest, URI httpURI, C context) {
        Span span = this.tracer.createExitChildSpan();
        if (span == null) {
            return null;
        }
        this.enrichSpan(span, sdkRequest, httpURI, context);
        return span;
    }
}

