/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import javax.annotation.Nullable;

public abstract class AbstractAwsSdkInstrumentationHelper<R, C> {
    protected final IAwsSdkDataSource<R, C> awsSdkDataSource;
    protected final ElasticApmTracer tracer;

    protected AbstractAwsSdkInstrumentationHelper(ElasticApmTracer tracer, IAwsSdkDataSource<R, C> awsSdkDataSource) {
        this.tracer = tracer;
        this.awsSdkDataSource = awsSdkDataSource;
    }

    public ElasticApmTracer getTracer() {
        return this.tracer;
    }

    @Nullable
    public abstract Span startSpan(R var1, URI var2, C var3);

    protected void setDestinationContext(Span span, @Nullable URI uri, R sdkRequest, C context, String type, @Nullable String name) {
        if (uri != null) {
            span.getContext().getDestination().withAddress(uri.getHost()).withPort(uri.getPort());
        }
        span.getContext().getServiceTarget().withType(type).withName(name).withNameOnlyDestinationResource();
        span.getContext().getDestination().getCloud().withRegion(this.awsSdkDataSource.getRegion(sdkRequest, context));
    }
}

