/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.InstrumentationStats;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.metadata.FaaSMetaDataExtension;
import co.elastic.apm.agent.impl.metadata.Framework;
import co.elastic.apm.agent.impl.metadata.NameAndIdField;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import co.elastic.apm.agent.util.VersionUtils;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractLambdaTransactionHelper<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLambdaTransactionHelper.class);
    private static final Logger enabledInstrumentationsLogger = LoggerUtils.logOnce(logger);
    protected final ElasticApmTracer tracer;
    protected final ServerlessConfiguration serverlessConfiguration;
    protected final CoreConfiguration coreConfiguration;
    protected final WebConfiguration webConfiguration;
    private static boolean coldStart = true;
    @Nullable
    private String functionArn;

    protected AbstractLambdaTransactionHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
        this.serverlessConfiguration = tracer.getConfig(ServerlessConfiguration.class);
    }

    protected abstract void setTransactionTriggerData(Transaction var1, I var2);

    @Nullable
    protected abstract Transaction doStartTransaction(I var1, Context var2);

    protected abstract void captureOutputForTransaction(Transaction var1, O var2);

    @Nullable
    public Transaction startTransaction(I input, Context lambdaContext) {
        Transaction transaction;
        boolean isColdStart = coldStart;
        if (isColdStart) {
            this.completeMetaData(lambdaContext);
            coldStart = false;
        }
        if (null != (transaction = this.doStartTransaction(input, lambdaContext))) {
            transaction.getFaas().withId(this.getFaasId(lambdaContext)).withName(lambdaContext.getFunctionName()).withVersion(lambdaContext.getFunctionVersion()).withColdStart(isColdStart).withExecution(lambdaContext.getAwsRequestId());
            transaction.getContext().getCloudOrigin().withProvider("aws");
            this.setTransactionName(transaction, input, lambdaContext);
            this.setTransactionTriggerData(transaction, input);
            return (Transaction)transaction.activate();
        }
        return null;
    }

    private String getFaasId(Context lambdaContext) {
        if (this.functionArn == null) {
            this.functionArn = lambdaContext.getInvokedFunctionArn();
            String[] arnSegments = this.functionArn.split(":");
            if (arnSegments.length > 7) {
                this.functionArn = this.functionArn.substring(0, this.functionArn.lastIndexOf(58));
            }
        }
        return this.functionArn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeTransaction(Transaction transaction, @Nullable O output, @Nullable Throwable thrown) {
        try {
            if (null != output) {
                this.captureOutputForTransaction(transaction, output);
            }
            if (thrown != null) {
                transaction.captureException(thrown);
                transaction.withResultIfUnset("failure");
            } else {
                transaction.withResultIfUnset("success");
            }
        }
        finally {
            ((Transaction)transaction.deactivate()).end();
        }
        long flushTimeout = this.serverlessConfiguration.getDataFlushTimeout();
        try {
            if (!this.tracer.getReporter().flush(flushTimeout, TimeUnit.MILLISECONDS, true)) {
                logger.error("APM data flush haven't completed within {} milliseconds.", (Object)flushTimeout);
            }
        }
        catch (Exception e) {
            logger.error("An error occurred on flushing APM data.", e);
        }
        this.logEnabledInstrumentations();
    }

    private void logEnabledInstrumentations() {
        if (enabledInstrumentationsLogger.isInfoEnabled()) {
            InstrumentationStats instrumentationStats = ElasticApmAgent.getInstrumentationStats();
            enabledInstrumentationsLogger.info("Used instrumentation groups: {}", (Object)instrumentationStats.getUsedInstrumentationGroups());
        }
    }

    private void completeMetaData(Context lambdaContext) {
        try {
            String[] arnSegments = lambdaContext.getInvokedFunctionArn().split(":");
            String region = arnSegments[3];
            String accountId = arnSegments[4];
            String lambdaLibVersion = VersionUtils.getVersion(RequestHandler.class, "com.amazonaws", "aws-lambda-java-core");
            if (lambdaLibVersion == null) {
                lambdaLibVersion = "unknown";
            }
            this.tracer.getMetaDataFuture().getFaaSMetaDataExtensionFuture().complete(new FaaSMetaDataExtension(new Framework("AWS Lambda", lambdaLibVersion), new NameAndIdField(null, accountId), region));
        }
        catch (Exception e) {
            logger.error("Failed updating metadata for first lambda execution!", e);
        }
    }

    protected void setTransactionName(Transaction transaction, I event, Context lambdaContext) {
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        if (transactionName != null) {
            transactionName.append(lambdaContext.getFunctionName());
        }
    }
}

