/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.MapTextHeaderGetter;
import co.elastic.apm.agent.awslambda.helper.AbstractAPIGatewayTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import javax.annotation.Nullable;

public class APIGatewayProxyV2TransactionHelper
extends AbstractAPIGatewayTransactionHelper<APIGatewayV2HTTPEvent, APIGatewayV2HTTPResponse> {
    @Nullable
    private static APIGatewayProxyV2TransactionHelper INSTANCE;

    private APIGatewayProxyV2TransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public static APIGatewayProxyV2TransactionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new APIGatewayProxyV2TransactionHelper(GlobalTracer.requireTracerImpl());
        }
        return INSTANCE;
    }

    @Override
    protected Transaction doStartTransaction(APIGatewayV2HTTPEvent apiGatewayEvent, Context lambdaContext) {
        Transaction transaction = this.tracer.startChildTransaction(apiGatewayEvent.getHeaders(), MapTextHeaderGetter.INSTANCE, PrivilegedActionUtils.getClassLoader(apiGatewayEvent.getClass()));
        APIGatewayV2HTTPEvent.RequestContext requestContext = apiGatewayEvent.getRequestContext();
        if (transaction != null) {
            APIGatewayV2HTTPEvent.RequestContext.Http http = requestContext.getHttp();
            this.fillHttpRequestData(transaction, http.getMethod(), apiGatewayEvent.getHeaders(), requestContext.getDomainName(), http.getPath(), apiGatewayEvent.getRawQueryString(), apiGatewayEvent.getBody());
            transaction.getContext().getRequest().withHttpVersion(http.getProtocol());
        }
        return transaction;
    }

    @Override
    public void captureOutputForTransaction(Transaction transaction, APIGatewayV2HTTPResponse responseEvent) {
        this.fillHttpResponseData(transaction, responseEvent.getHeaders(), responseEvent.getStatusCode());
    }

    @Override
    protected void setTransactionTriggerData(Transaction transaction, APIGatewayV2HTTPEvent apiGatewayRequest) {
        super.setTransactionTriggerData(transaction, apiGatewayRequest);
        APIGatewayV2HTTPEvent.RequestContext rContext = apiGatewayRequest.getRequestContext();
        this.setApiGatewayContextData(transaction, rContext.getRequestId(), rContext.getApiId(), rContext.getDomainName(), rContext.getAccountId());
    }

    @Override
    protected String getApiGatewayVersion() {
        return "2.0";
    }

    @Override
    @Nullable
    protected String getHttpMethod(APIGatewayV2HTTPEvent event) {
        return event.getRequestContext().getHttp().getMethod();
    }

    @Override
    @Nullable
    protected String getRequestContextPath(APIGatewayV2HTTPEvent event) {
        return event.getRequestContext().getHttp().getPath();
    }

    @Override
    @Nullable
    protected String getStage(APIGatewayV2HTTPEvent event) {
        String stage = event.getRequestContext().getStage();
        if (stage != null && !stage.equals("$default")) {
            return stage;
        }
        return null;
    }

    @Override
    @Nullable
    protected String getResourcePath(APIGatewayV2HTTPEvent event) {
        int idxSpace;
        String routeKey = event.getRequestContext().getRouteKey();
        if (routeKey != null && (idxSpace = routeKey.indexOf(32)) >= 0 && routeKey.length() > idxSpace + 1) {
            routeKey = routeKey.substring(idxSpace + 1);
        }
        return routeKey;
    }
}

