/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda;

import co.elastic.apm.agent.awslambda.AbstractAwsLambdaHandlerInstrumentation;
import co.elastic.apm.agent.awslambda.helper.PlainTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class RequestStreamHandlerInstrumentation
extends AbstractAwsLambdaHandlerInstrumentation {
    public RequestStreamHandlerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        String matchMethod = this.handlerMethodName != null ? this.handlerMethodName : "handleRequest";
        return ElementMatchers.isPublic().and(ElementMatchers.named(matchMethod)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.io.InputStream"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("java.io.OutputStream"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("com.amazonaws.services.lambda.runtime.Context")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.awslambda.RequestStreamHandlerInstrumentation$RequestStreamHandlerAdvice";
    }

    public static class RequestStreamHandlerAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object handlerEnter(@Advice.Argument(value=0) InputStream inputStream, @Advice.Argument(value=2) Context lambdaContext) {
            return PlainTransactionHelper.getInstance().startTransaction(inputStream, lambdaContext);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void handlerExit(@Nullable @Advice.Enter Object transactionObj, @Nullable @Advice.Thrown Throwable thrown) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                PlainTransactionHelper.getInstance().finalizeTransaction(transaction, null, thrown);
            }
        }
    }
}

