/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda;

import co.elastic.apm.agent.awslambda.AbstractAwsLambdaHandlerInstrumentation;
import co.elastic.apm.agent.awslambda.helper.AWSEventsHelper;
import co.elastic.apm.agent.awslambda.helper.PlainTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class RequestHandlerInstrumentation
extends AbstractAwsLambdaHandlerInstrumentation {
    public RequestHandlerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        String matchMethod = this.handlerMethodName != null ? this.handlerMethodName : "handleRequest";
        return ElementMatchers.isPublic().and(ElementMatchers.named(matchMethod)).and(ElementMatchers.takesArgument(1, ElementMatchers.named("com.amazonaws.services.lambda.runtime.Context")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.awslambda.RequestHandlerInstrumentation$RequestHandlerAdvice";
    }

    public static class RequestHandlerAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object handlerEnter(@Nullable @Advice.Argument(value=0) Object input, @Advice.Argument(value=1) Context lambdaContext) {
            if (input != null && input.getClass().getName().startsWith("com.amazonaws.services.lambda.runtime.events")) {
                return AWSEventsHelper.startTransaction(input, lambdaContext);
            }
            return PlainTransactionHelper.getInstance().startTransaction(input, lambdaContext);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void handlerExit(@Nullable @Advice.Enter Object transactionObj, @Nullable @Advice.Thrown Throwable thrown, @Nullable @Advice.Return Object output) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                if (output != null && output.getClass().getName().startsWith("com.amazonaws.services.lambda.runtime.events")) {
                    AWSEventsHelper.finalizeTransaction(transaction, output, thrown);
                } else {
                    PlainTransactionHelper.getInstance().finalizeTransaction(transaction, output, thrown);
                }
            }
        }
    }
}

