/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.configuration.source;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.source.AbstractConfigurationSource;

public class SystemPropertyConfigurationSource
extends AbstractConfigurationSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getValue(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            this.logger.warn("Could not get Java system property, because of a SecurityException: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        return "Java System Properties";
    }
}

