/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j;

import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.log4j.MdcAccess;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class EcsLayout
extends Layout {
    private static final MdcAccess MDC_ACCESS = MdcAccess.Resolver.resolve();
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private String serviceVersion;
    private String serviceNodeName;
    private boolean includeOrigin;
    private String eventDataset;
    private List<AdditionalField> additionalFields = new ArrayList<AdditionalField>();

    public String format(LoggingEvent event) {
        ThrowableInformation throwableInformation;
        LocationInfo locationInformation;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart(builder, event.timeStamp);
        EcsJsonSerializer.serializeLogLevel(builder, event.level.toString());
        EcsJsonSerializer.serializeFormattedMessage(builder, event.getRenderedMessage());
        EcsJsonSerializer.serializeEcsVersion(builder);
        EcsJsonSerializer.serializeServiceName(builder, this.serviceName);
        EcsJsonSerializer.serializeServiceVersion(builder, this.serviceVersion);
        EcsJsonSerializer.serializeServiceNodeName(builder, this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset(builder, this.eventDataset);
        EcsJsonSerializer.serializeThreadName(builder, event.getThreadName());
        EcsJsonSerializer.serializeLoggerName(builder, event.categoryName);
        EcsJsonSerializer.serializeAdditionalFields(builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC(builder, MDC_ACCESS.getMDC(event));
        EcsJsonSerializer.serializeTag(builder, event.getNDC());
        if (this.includeOrigin && (locationInformation = event.getLocationInformation()) != null) {
            EcsJsonSerializer.serializeOrigin(builder, locationInformation.getFileName(), locationInformation.getMethodName(), EcsLayout.getLineNumber(locationInformation));
        }
        if ((throwableInformation = event.getThrowableInformation()) != null) {
            EcsJsonSerializer.serializeException(builder, throwableInformation.getThrowable(), this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd(builder);
        return builder.toString();
    }

    private static int getLineNumber(LocationInfo locationInformation) {
        int lineNumber = -1;
        String lineNumberString = locationInformation.getLineNumber();
        if (!"?".equals(lineNumberString)) {
            try {
                lineNumber = Integer.parseInt(lineNumberString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return lineNumber;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
        this.eventDataset = EcsJsonSerializer.computeEventDataset(this.eventDataset, this.serviceName);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public void setAdditionalField(String additionalField) {
        this.additionalFields.add(AdditionalField.of(additionalField));
    }
}

