/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.jul;

import java.util.Collections;
import java.util.Map;
import org.slf4j.MDC;

public interface MdcSupplier {
    public Map<String, String> getMDC();

    public static enum Unavailable implements MdcSupplier
    {
        INSTANCE;


        @Override
        public Map<String, String> getMDC() {
            return Collections.emptyMap();
        }
    }

    public static enum Available implements MdcSupplier
    {
        INSTANCE;


        @Override
        public Map<String, String> getMDC() {
            Map<String, String> copyOfContextMap = MDC.getCopyOfContextMap();
            if (copyOfContextMap != null) {
                return copyOfContextMap;
            }
            return Collections.emptyMap();
        }
    }

    public static enum Resolver {
        INSTANCE;


        MdcSupplier resolve() {
            try {
                Class.forName("org.slf4j.MDC");
                Class.forName("org.slf4j.impl.StaticMDCBinder");
                return (MdcSupplier)Class.forName("co.elastic.logging.jul.MdcSupplier$Available").getEnumConstants()[0];
            }
            catch (Exception e) {
                return Unavailable.INSTANCE;
            }
            catch (LinkageError e) {
                return Unavailable.INSTANCE;
            }
        }
    }
}

