/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.jul;

import co.elastic.logging.AdditionalField;
import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.jul.MdcSupplier;
import java.util.Collections;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class EcsFormatter
extends Formatter {
    private static final String UNKNOWN_FILE = "<Unknown>";
    private static final MdcSupplier mdcSupplier = MdcSupplier.Resolver.INSTANCE.resolve();
    private boolean stackTraceAsArray;
    private String serviceName;
    private String serviceVersion;
    private String serviceNodeName;
    private boolean includeOrigin;
    private String eventDataset;
    private List<AdditionalField> additionalFields = Collections.emptyList();

    public EcsFormatter() {
        this.serviceName = this.getProperty("co.elastic.logging.jul.EcsFormatter.serviceName", null);
        this.serviceVersion = this.getProperty("co.elastic.logging.jul.EcsFormatter.serviceVersion", null);
        this.serviceNodeName = this.getProperty("co.elastic.logging.jul.EcsFormatter.serviceNodeName", null);
        this.includeOrigin = Boolean.parseBoolean(this.getProperty("co.elastic.logging.jul.EcsFormatter.includeOrigin", "false"));
        this.stackTraceAsArray = Boolean.parseBoolean(this.getProperty("co.elastic.logging.jul.EcsFormatter.stackTraceAsArray", "false"));
        this.eventDataset = this.getProperty("co.elastic.logging.jul.EcsFormatter.eventDataset", null);
        this.eventDataset = EcsJsonSerializer.computeEventDataset(this.eventDataset, this.serviceName);
        this.setAdditionalFields(this.getProperty("co.elastic.logging.jul.EcsFormatter.additionalFields", null));
    }

    @Override
    public String format(LogRecord record) {
        Throwable throwableInformation;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart(builder, record.getMillis());
        EcsJsonSerializer.serializeLogLevel(builder, record.getLevel().getName());
        EcsJsonSerializer.serializeFormattedMessage(builder, super.formatMessage(record));
        EcsJsonSerializer.serializeEcsVersion(builder);
        EcsJsonSerializer.serializeAdditionalFields(builder, this.additionalFields);
        EcsJsonSerializer.serializeMDC(builder, mdcSupplier.getMDC());
        EcsJsonSerializer.serializeServiceName(builder, this.serviceName);
        EcsJsonSerializer.serializeServiceVersion(builder, this.serviceVersion);
        EcsJsonSerializer.serializeServiceNodeName(builder, this.serviceNodeName);
        EcsJsonSerializer.serializeEventDataset(builder, this.eventDataset);
        if (Thread.currentThread().getId() == (long)record.getThreadID()) {
            EcsJsonSerializer.serializeThreadName(builder, Thread.currentThread().getName());
        } else {
            EcsJsonSerializer.serializeThreadId(builder, record.getThreadID());
        }
        EcsJsonSerializer.serializeLoggerName(builder, record.getLoggerName());
        if (this.includeOrigin && record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            EcsJsonSerializer.serializeOrigin(builder, this.buildFileName(record.getSourceClassName()), record.getSourceMethodName(), -1);
        }
        if ((throwableInformation = record.getThrown()) != null) {
            EcsJsonSerializer.serializeException(builder, throwableInformation, this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd(builder);
        return builder.toString();
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setEventDataset(String eventDataset) {
        this.eventDataset = eventDataset;
    }

    public void setAdditionalFields(String additionalFields) {
        this.additionalFields = AdditionalField.parse(additionalFields);
    }

    public void setAdditionalFields(List<AdditionalField> additionalFields) {
        this.additionalFields = additionalFields;
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }

    private String buildFileName(String className) {
        String result = UNKNOWN_FILE;
        if (className != null) {
            int classNameStart;
            int fileNameEnd = className.indexOf(36);
            if (fileNameEnd < 0) {
                fileNameEnd = className.length();
            }
            if ((classNameStart = className.lastIndexOf(46)) < fileNameEnd) {
                result = className.substring(classNameStart + 1, fileNameEnd) + ".java";
            }
        }
        return result;
    }
}

