/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.websocket;

import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.util.VersionUtils;
import co.elastic.apm.agent.websocket.BaseServerEndpointInstrumentation;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.websocket.server.ServerEndpoint;
import net.bytebuddy.asm.Advice;

public class JavaxServerEndpointInstrumentation
extends BaseServerEndpointInstrumentation {
    public JavaxServerEndpointInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("websocket", "javax-websocket");
    }

    @Override
    protected String getServerEndpointClassName() {
        return "javax.websocket.server.ServerEndpoint";
    }

    public static class AdviceClass
    extends BaseServerEndpointInstrumentation.BaseAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onMethodEnter(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature) {
            String frameworkVersion = VersionUtils.getVersion(ServerEndpoint.class, "javax.websocket", "javax.websocket-api");
            return AdviceClass.startTransactionOrSetTransactionName(signature, "Java WebSocket", frameworkVersion);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object transactionOrNull, @Advice.Thrown @Nullable Throwable t) {
            AdviceClass.endTransaction(transactionOrNull, t);
        }
    }
}

