/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http2;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http2ServerRequestImpl;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Http2StartTransactionInstrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.Http2ServerConnection");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("createRequest").and(ElementMatchers.returns(ElementMatchers.named("io.vertx.core.http.impl.Http2ServerRequestImpl")));
    }

    public static class AdviceClass {
        private static final Logger log = LoggerFactory.getLogger(AdviceClass.class);

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void exit(@Advice.Return Http2ServerRequestImpl request) {
            Transaction transaction = WebHelper.getInstance().startOrGetTransaction((HttpServerRequest)request);
            if (transaction != null) {
                WebHelper.getInstance().mapTransaction(request.response(), transaction);
            }
            log.debug("VERTX-DEBUG: started Vert.x 3.x HTTP 2 transaction: {}", (Object)transaction);
        }
    }
}

