/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http2;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.http.impl.Http2ServerResponseImpl;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class Http2ServerResponseImplEndInstrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.Http2ServerResponseImpl");
    }

    public static class CloseInstrumentation
    extends Http2ServerResponseImplEndInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("close");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.web.http2.Http2ServerResponseImplEndInstrumentation$CloseInstrumentation$CloseAdvice";
        }

        public static class CloseAdvice {
            private static final Logger log = LoggerFactory.getLogger(CloseAdvice.class);

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void closeExit(@Advice.This Http2ServerResponseImpl response) {
                Transaction transaction = WebHelper.getInstance().removeTransactionMapping(response);
                log.debug("VERTX-DEBUG: removing transaction {} mapping to response {}", (Object)transaction, (Object)response);
            }
        }
    }

    public static class WriteInstrumentation
    extends Http2ServerResponseImplEndInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("write").and(ElementMatchers.takesArgument(1, Boolean.TYPE));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.vertx.v3.web.http2.Http2ServerResponseImplEndInstrumentation$WriteInstrumentation$WriteAdvice";
        }

        public static class WriteAdvice {
            private static final Logger log = LoggerFactory.getLogger(WriteAdvice.class);

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void writeExit(@Advice.This Http2ServerResponseImpl response, @Advice.Argument(value=1) boolean end) {
                if (end) {
                    Transaction transaction = WebHelper.getInstance().removeTransactionMapping(response);
                    log.debug("VERTX-DEBUG: removing transaction {} mapping to response {}", (Object)transaction, (Object)response);
                }
            }
        }
    }
}

