/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx;

import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpContext;
import java.net.URI;
import javax.annotation.Nullable;

public abstract class AbstractVertxWebClientHelper {
    private static final String WEB_CLIENT_SPAN_KEY = AbstractVertxWebClientHelper.class.getName() + ".span";

    public void startSpan(AbstractSpan<?> parent, HttpContext<?> httpContext, HttpClientRequest httpRequest) {
        Object existingSpanObj = httpContext.get(WEB_CLIENT_SPAN_KEY);
        if (existingSpanObj != null) {
            ((Span)existingSpanObj).propagateTraceContext(httpRequest, HeaderSetter.INSTANCE);
        } else {
            URI requestUri = URI.create(httpRequest.absoluteURI());
            Span span = HttpClientHelper.startHttpClientSpan(parent, this.getMethod(httpRequest), requestUri, null);
            if (span != null) {
                span.propagateTraceContext(httpRequest, HeaderSetter.INSTANCE);
                span.incrementReferences();
                httpContext.set(WEB_CLIENT_SPAN_KEY, (Object)span);
            } else {
                parent.propagateTraceContext(httpRequest, HeaderSetter.INSTANCE);
            }
        }
    }

    public void followRedirect(HttpContext<?> httpContext, HttpClientRequest httpRequest) {
        Object existingSpanObj = httpContext.get(WEB_CLIENT_SPAN_KEY);
        if (existingSpanObj != null) {
            Span existingSpan = (Span)existingSpanObj;
            existingSpan.propagateTraceContext(httpRequest, HeaderSetter.INSTANCE);
        }
    }

    public void endSpan(HttpContext<?> httpContext, HttpResponse<?> httpResponse) {
        this.finalizeSpan(httpContext, httpResponse.statusCode(), null, null);
    }

    public void failSpan(HttpContext<?> httpContext, Throwable thrown, @Nullable AbstractSpan<?> parent) {
        this.finalizeSpan(httpContext, 0, thrown, parent);
    }

    private void finalizeSpan(HttpContext<?> httpContext, int statusCode, @Nullable Throwable thrown, @Nullable AbstractSpan<?> parent) {
        Object spanObj = httpContext.get(WEB_CLIENT_SPAN_KEY);
        if (spanObj != null) {
            httpContext.set(WEB_CLIENT_SPAN_KEY, null);
            Span span = (Span)spanObj;
            span.decrementReferences();
            if (thrown != null) {
                ((Span)span.captureException(thrown)).withOutcome(Outcome.FAILURE);
            }
            if (statusCode > 0) {
                span.getContext().getHttp().withStatusCode(statusCode);
            }
            span.end();
        } else if (parent != null) {
            parent.captureException(thrown);
        }
    }

    protected abstract String getMethod(HttpClientRequest var1);

    static class HeaderSetter
    implements TextHeaderSetter<HttpClientRequest> {
        public static final HeaderSetter INSTANCE = new HeaderSetter();

        HeaderSetter() {
        }

        @Override
        public void setHeader(String headerName, String headerValue, HttpClientRequest carrier) {
            carrier.putHeader(headerName, headerValue);
        }
    }
}

