/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.httpserver.HttpServerHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.TransactionNameUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractHttpTransactionHelper {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpTransactionHelper.class);
    private static final String CONTENT_TYPE_FROM_URLENCODED = "application/x-www-form-urlencoded";
    private static final Set<String> METHODS_WITH_BODY = new HashSet<String>(Arrays.asList("POST", "PUT", "PATCH", "DELETE"));
    private static final WildcardMatcher ENDS_WITH_JSP = WildcardMatcher.valueOf("*.jsp");
    protected static final String CONTENT_TYPE_HEADER = "Content-Type";
    protected static final String USER_AGENT_HEADER = "User-Agent";
    protected final Tracer tracer;
    protected final WebConfiguration webConfiguration;
    protected final CoreConfiguration coreConfiguration;
    protected final HttpServerHelper serverHelper;

    protected AbstractHttpTransactionHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.webConfiguration = tracer.getConfig(WebConfiguration.class);
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.serverHelper = new HttpServerHelper(this.webConfiguration);
    }

    protected void startCaptureBody(Transaction transaction, String method, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method)) {
            if (this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && contentTypeHeader != null && !contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader)) {
                request.withBodyBuffer();
            } else {
                request.redactBody();
                if (this.coreConfiguration.getCaptureBody() == CoreConfiguration.EventType.OFF) {
                    logger.debug("Not capturing Request body because the capture_body config option is OFF");
                }
                if (contentTypeHeader == null) {
                    logger.debug("Not capturing request body because couldn't find Content-Type header");
                } else if (!contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
                    logger.debug("Not capturing body for content type \"{}\". Consider updating the capture_body_content_types configuration option.", (Object)contentTypeHeader);
                }
            }
        }
    }

    protected boolean hasBody(@Nullable String contentTypeHeader, String method) {
        return METHODS_WITH_BODY.contains(method) && contentTypeHeader != null;
    }

    public void applyDefaultTransactionName(String method, String pathFirstPart, @Nullable String pathSecondPart, Transaction transaction, int priorityOffset) {
        if (this.webConfiguration.isUsePathAsName() || ENDS_WITH_JSP.matches(pathFirstPart, pathSecondPart)) {
            TransactionNameUtils.setNameFromHttpRequestPath(method, pathFirstPart, pathSecondPart, transaction.getAndOverrideName(11 + priorityOffset), this.webConfiguration.getUrlGroups());
        } else {
            TransactionNameUtils.setNameFromHttpRequestPath(method, "unknown route", null, transaction.getAndOverrideName(0), this.webConfiguration.getUrlGroups());
        }
    }

    protected void fillRequestParameters(Transaction transaction, String method, @Nullable Map<String, String[]> parameterMap, @Nullable String contentTypeHeader) {
        Request request = transaction.getContext().getRequest();
        if (this.hasBody(contentTypeHeader, method) && this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && parameterMap != null) {
            this.captureParameters(request, parameterMap, contentTypeHeader);
        }
    }

    private void captureParameters(Request request, Map<String, String[]> params, @Nullable String contentTypeHeader) {
        if (contentTypeHeader != null && contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED)) {
            for (Map.Entry<String, String[]> param : params.entrySet()) {
                request.addFormUrlEncodedParameters(param.getKey(), param.getValue());
            }
        }
    }

    public boolean captureParameters(String method, @Nullable String contentTypeHeader) {
        return contentTypeHeader != null && contentTypeHeader.startsWith(CONTENT_TYPE_FROM_URLENCODED) && this.hasBody(contentTypeHeader, method) && this.coreConfiguration.getCaptureBody() != CoreConfiguration.EventType.OFF && WildcardMatcher.isAnyMatch(this.webConfiguration.getCaptureContentTypes(), contentTypeHeader);
    }

    protected void fillResponse(Response response, @Nullable Boolean committed, int status) {
        response.withFinished(true);
        if (committed != null) {
            response.withHeadersSent(committed);
        }
        response.withStatusCode(status);
    }

    protected void fillRequest(Request request, String protocol, String method, @Nullable String scheme, @Nullable String serverName, int serverPort, String requestURI, @Nullable String queryString, @Nullable String remoteAddr) {
        this.fillRequest(request, protocol, method, remoteAddr);
        this.fillUrlRelatedFields(request, scheme, serverName, serverPort, requestURI, queryString);
    }

    protected void fillRequest(Request request, String protocol, String method, @Nullable String remoteAddr) {
        request.withHttpVersion(protocol);
        request.withMethod(method);
        request.getSocket().withRemoteAddress(remoteAddr);
    }

    protected void fillUrlRelatedFields(Request request, @Nullable String scheme, @Nullable String serverName, int serverPort, String requestURI, @Nullable String queryString) {
        request.getUrl().resetState();
        request.getUrl().withProtocol(scheme).withHostname(serverName).withPort(serverPort).withPathname(requestURI).withSearch(queryString);
    }

    public boolean isCaptureHeaders() {
        return this.coreConfiguration.isCaptureHeaders();
    }
}

