/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import javax.annotation.Nullable;

public class DependencyInjectingServiceLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(DependencyInjectingServiceLoader.class);
    private final Class<T> clazz;
    private final Object[] constructorArguments;
    private final Class<?>[] constructorTypes;
    private final List<T> instances = new ArrayList<T>();
    private final Set<Class<?>> implementationClassCache;
    private final Set<URL> resourcePathCache;

    private DependencyInjectingServiceLoader(Class<T> clazz, Object ... constructorArguments) {
        this(clazz, Collections.singletonList(clazz.getClassLoader()), constructorArguments);
    }

    private DependencyInjectingServiceLoader(Class<T> clazz, List<ClassLoader> classLoaders, Object ... constructorArguments) {
        this.clazz = clazz;
        this.constructorArguments = constructorArguments;
        ArrayList types = new ArrayList(constructorArguments.length);
        for (Object constructorArgument : constructorArguments) {
            types.add(constructorArgument.getClass());
        }
        this.constructorTypes = types.toArray(new Class[0]);
        this.implementationClassCache = new HashSet();
        this.resourcePathCache = new HashSet<URL>();
        try {
            for (ClassLoader classLoader : classLoaders) {
                Enumeration<URL> resources = this.getServiceDescriptors(classLoader, clazz);
                this.instantiate(classLoader, this.getImplementations(resources));
            }
        }
        catch (IOException e) {
            throw new ServiceConfigurationError(e.getMessage(), e);
        }
    }

    private Enumeration<URL> getServiceDescriptors(@Nullable ClassLoader classLoader, Class<T> clazz) throws IOException {
        if (classLoader != null) {
            return classLoader.getResources("META-INF/services/" + clazz.getName());
        }
        return ClassLoader.getSystemResources("META-INF/services/" + clazz.getName());
    }

    public static <T> List<T> load(Class<T> clazz, Object ... constructorArguments) {
        return new DependencyInjectingServiceLoader<T>(clazz, (Object[])constructorArguments).instances;
    }

    public static <T> List<T> load(Class<T> clazz, List<ClassLoader> classLoaders, Object ... constructorArguments) {
        return new DependencyInjectingServiceLoader<T>(clazz, classLoaders, (Object[])constructorArguments).instances;
    }

    private static boolean isComment(String serviceImplementationClassName) {
        return serviceImplementationClassName.startsWith("#");
    }

    private Set<String> getImplementations(Enumeration<URL> resources) throws IOException {
        LinkedHashSet<String> implementations = new LinkedHashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!this.resourcePathCache.add(url)) continue;
            InputStream inputStream = url.openStream();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                while (reader.ready()) {
                    String line = reader.readLine().trim();
                    if (DependencyInjectingServiceLoader.isComment(line) || line.isEmpty()) continue;
                    implementations.add(line);
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return implementations;
    }

    private void instantiate(ClassLoader classLoader, Set<String> implementations) {
        for (String implementation : implementations) {
            T instance = this.instantiate(classLoader, implementation);
            if (instance == null) continue;
            this.instances.add(instance);
        }
    }

    @Nullable
    private T instantiate(ClassLoader classLoader, String implementation) {
        try {
            Class<?> implementationClass = Class.forName(implementation, true, classLoader);
            if (!this.implementationClassCache.add(implementationClass)) {
                return null;
            }
            DependencyInjectingServiceLoader.checkClassModifiers(implementationClass);
            Constructor<?> constructor = this.getMatchingConstructor(implementationClass);
            if (constructor != null) {
                DependencyInjectingServiceLoader.checkConstructorModifiers(constructor);
                return this.clazz.cast(constructor.newInstance(this.constructorArguments));
            }
            constructor = implementationClass.getConstructor(new Class[0]);
            DependencyInjectingServiceLoader.checkConstructorModifiers(constructor);
            return this.clazz.cast(constructor.newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            String msg = String.format("unable to instantiate '%s', please check descriptor in META-INF", implementation);
            throw new ServiceConfigurationError(msg, e);
        }
        catch (UnsupportedClassVersionError e) {
            logger.debug("Skipping {} because it only applies to more recent Java versions and the JVM running this app is too old to load it", (Object)implementation);
            return null;
        }
        catch (Exception e) {
            throw new ServiceConfigurationError(e.getMessage(), e);
        }
    }

    private static void checkConstructorModifiers(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new ServiceConfigurationError("constructor is not public : " + constructor);
        }
    }

    private static void checkClassModifiers(Class<?> clazz) {
        boolean isAbstract = Modifier.isAbstract(clazz.getModifiers());
        boolean isPublic = Modifier.isPublic(clazz.getModifiers());
        if (isAbstract || !isPublic) {
            throw new ServiceConfigurationError(String.format("unable to instantiate '%s' because it's either abstract or not public", clazz));
        }
    }

    @Nullable
    private Constructor<?> getMatchingConstructor(Class<?> implementationClass) {
        for (Constructor<?> constructor : implementationClass.getConstructors()) {
            if (!this.isAllAssignableFrom(constructor.getParameterTypes(), this.constructorTypes)) continue;
            return constructor;
        }
        return null;
    }

    private boolean isAllAssignableFrom(Class<?>[] types, Class<?>[] otherTypes) {
        if (types.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isAssignableFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }
}

