/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import javax.annotation.Nullable;

public class ClassLoaderUtils {
    public static boolean isPersistentClassLoader(@Nullable ClassLoader classLoader) {
        try {
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static boolean isAgentClassLoader(@Nullable ClassLoader classLoader) {
        return classLoader != null && classLoader.getClass().getName().startsWith("co.elastic.apm") || ClassLoaderUtils.class.getClassLoader().equals(classLoader);
    }

    public static boolean isBootstrapClassLoader(@Nullable ClassLoader classLoader) {
        return classLoader == null;
    }
}

